package eva.ambidexterity.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import eva.ambidexterity.access.BlockAccess;
import eva.ambidexterity.access.LivingEntityAccess;
import eva.ambidexterity.access.ServerPlayerGameModeAccess;
import net.minecraft.class_1934;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2846.class_2847;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3225.class)
public class ServerPlayerGameModeMixin implements ServerPlayerGameModeAccess {

    @Final @Shadow protected class_3222 player;
    @Shadow private class_1934 gameModeForPlayer;
    @Shadow private int delayedTickStart;
    @Shadow private int destroyProgressStart;
    @Shadow private boolean hasDelayedDestroy;
    @Shadow private class_2338 delayedDestroyPos;
    @Shadow private class_2338 destroyPos;
    @Shadow private int lastSentState;
    @Shadow private boolean isDestroyingBlock;

    @Unique private final class_3225 spgm = (class_3225) (Object) this;

    @Inject(
            method = "tick",
            at = @At(value = "TAIL")
    )
    public void tick(CallbackInfo ci) {
        boolean varHolder = ((LivingEntityAccess) player).isOffhand();
        ((LivingEntityAccess) player).offhand(true);
        if (hasDelayedDestroy) {
            class_2680 blockState = this.player.method_37908().method_8320(delayedDestroyPos);
            if (blockState.method_26215()) {
                hasDelayedDestroy = false;
            } else {
                float f = spgm.method_21716(blockState, delayedDestroyPos, delayedTickStart);
                if (f >= 1.0F) {
                    hasDelayedDestroy = false;
                    spgm.method_14266(delayedDestroyPos);
                }
            }
        } else if (isDestroyingBlock) {
            class_2680 blockState = this.player.method_37908().method_8320(destroyPos);
            if (blockState.method_26215()) {
                this.player.method_37908().method_8517(player.method_5628(), destroyPos, -1);
                lastSentState = -1;
                isDestroyingBlock = false;
            } else {
                spgm.method_21716(blockState, destroyPos, destroyProgressStart);
            }
        }
        ((LivingEntityAccess) player).offhand(varHolder);
    }

    @Unique
    public void dualWielding$handleBlockBreakAction(class_2338 pos, class_2847 action, class_2350 direction, int worldHeight, int sequence) {
        boolean varHolder = this.isOffhand();
        this.offhand(true);
        spgm.method_14263(pos, action, direction, worldHeight, sequence);
        this.offhand(varHolder);
    }

//    @Redirect(
//            method = "handleBlockBreakAction",
//            at = @At(
//                    value = "FIELD",
//                    target = "Lnet/minecraft/server/level/ServerPlayerGameMode;isDestroyingBlock:Z",
//                    opcode = Opcodes.PUTFIELD
//            )
//    )
//    private void boolThief(ServerPlayerGameMode instance, boolean value) {
//        if (this.isOffhand()) this.isOffMine = value;
//        else isDestroyingBlock = value;
//    }

//    @ModifyExpressionValue(
//            method = "handleBlockBreakAction",
//            at = @At(
//                    value = "FIELD",
//                    target = "Lnet/minecraft/server/level/ServerPlayerGameMode;isDestroyingBlock:Z",
//                    opcode = Opcodes.GETFIELD
//            )
//    )
//    private boolean replaceBool(boolean original) {
//        if (this.isOffhand()) return this.isOffMine;
//        else return original;
//    }

//    @Inject(
//            method = "handleBlockBreakAction",
//            at = @At(
//                    value = "INVOKE",
//                    target = "Lnet/minecraft/server/level/ServerLevel;getBlockState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;"
//            )
//    )
//    private void setOffMine1(BlockPos pos, Action action, Direction face, int maxBuildHeight, int sequence, CallbackInfo ci) {
//        if (this.isOffhand()) this.isOffMine = true;
//    }

//    @ModifyExpressionValue(
//            method = "handleBlockBreakAction",
//            at = @At(
//                    value = "INVOKE",
//                    target = "Lnet/minecraft/server/level/ServerPlayer;blockActionRestricted(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/GameType;)Z"
//            )
//    )
//    private boolean blockActionChecker(boolean original, @Local(argsOnly = true) BlockPos pos) {
//        if (this.isOffhand()) return ((PlayerAccess)player).dualWielding$blockActionRestricted(this.player.level(), pos, gameModeForPlayer);
//        return original;
//    }

    @ModifyExpressionValue(
            method = "handleBlockBreakAction",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/level/block/state/BlockState;getDestroyProgress(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)F"
            )
    )
    private float destroyProgressReplacer(float original, @Local(argsOnly = true) class_2338 pos, @Local class_2680 blockState) {
        if (this.isOffhand())
            return ((BlockAccess) blockState).dualWielding$getDestroyProgress(player, this.player.method_37908(), pos);
        return original;
    }

    @Redirect(
            method = "handleBlockBreakAction",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/server/level/ServerPlayerGameMode;destroyAndAck(Lnet/minecraft/core/BlockPos;ILjava/lang/String;)V"
            )
    )
    private void redirectDestroyAndAck(class_3225 instance, class_2338 pos, int sequence, String message) {
        if (this.isOffhand()) this.dualWielding$destroyAndAck(pos, sequence, message);
        else instance.method_21717(pos, sequence, message);
    }

//    @Inject(
//            method = "handleBlockBreakAction",
//            at = @At(
//                    value = "INVOKE",
//                    target = "Lnet/minecraft/server/level/ServerPlayerGameMode;debugLogging(Lnet/minecraft/core/BlockPos;ZILjava/lang/String;)V",
//                    ordinal = 6
//            )
//    )
//    private void setOffMine2(BlockPos pos, Action action, Direction face, int maxBuildHeight, int sequence, CallbackInfo ci) {
//        if (this.isOffhand()) this.isOffMine = false;
//    }

//    @Inject(
//            method = "handleBlockBreakAction",
//            at = @At(
//                    value = "INVOKE",
//                    target = "Lnet/minecraft/server/level/ServerPlayerGameMode;debugLogging(Lnet/minecraft/core/BlockPos;ZILjava/lang/String;)V",
//                    ordinal = 8
//            )
//    )
//    private void setOffMine3(BlockPos pos, Action action, Direction face, int maxBuildHeight, int sequence, CallbackInfo ci) {
//        if (this.isOffhand()) this.isOffMine = false;
//    }

//    private void dummy(BlockPos pos, Action action, Direction direction, int worldHeight, int sequence) {
//        if (!player.canInteractWithBlock(pos, 1.0)) {
//            dualWielding$debugLogging(pos, false, sequence, "too far");
//        } else if (pos.getY() > worldHeight) {
//            player.connection.send(new ClientboundBlockUpdatePacket(pos, level.getBlockState(pos)));
//            dualWielding$debugLogging(pos, false, sequence, "too high");
//        } else {
//            if (action == Action.START_DESTROY_BLOCK) {
//                isOffMine = true;
//                if (!level.mayInteract(player, pos)) {
//                    player.connection.send(new ClientboundBlockUpdatePacket(pos, level.getBlockState(pos)));
//                    dualWielding$debugLogging(pos, false, sequence, "may not interact");
//                    return;
//                }
//
//                if (((PlayerAccess)player).dualWielding$blockActionRestricted(level, pos, gameModeForPlayer)) {
//                    player.connection.send(new ClientboundBlockUpdatePacket(pos, level.getBlockState(pos)));
//                    dualWielding$debugLogging(pos, false, sequence, "block action restricted");
//                    return;
//                }
//
//                destroyProgressStart = gameTicks;
//                float f = 1.0F;
//                BlockState blockState = level.getBlockState(pos);
//                if (!blockState.isAir()) {
//                    EnchantmentHelper.onHitBlock(
//                            level,
//                            player.getOffhandItem(),
//                            player,
//                            player,
//                            EquipmentSlot.MAINHAND,
//                            Vec3.atCenterOf(pos),
//                            blockState,
//                            item -> player.onEquippedItemBroken(item, EquipmentSlot.OFFHAND)
//                    );
//                    blockState.attack(level, pos, player);
//                    f = ((BlockAccess)blockState).dualWielding$getDestroyProgress(player, level, pos);
//                }
//
//                if (!blockState.isAir() && f >= 1.0F) {
//                    this.dualWielding$destroyAndAck(pos, sequence, "insta mine");
//                } else {
//                    if (isDestroyingBlock) {
//                        player.connection.send(new ClientboundBlockUpdatePacket(destroyPos, level.getBlockState(destroyPos)));
//                        dualWielding$debugLogging(pos, false, sequence, "abort destroying since another started (client insta mine, server disagreed)");
//                    }
//
//                    isDestroyingBlock = true;
//                    destroyPos = pos.immutable();
//                    int i = (int)(f * 10.0F);
//                    level.destroyBlockProgress(player.getId(), pos, i);
//                    dualWielding$debugLogging(pos, true, sequence, "actual start of destroying");
//                    lastSentState = i;
//                }
//            } else if (action == Action.STOP_DESTROY_BLOCK) {
//                isOffMine = false;
//                if (pos.equals(destroyPos)) {
//                    int j = gameTicks - destroyProgressStart;
//                    BlockState blockStatex = level.getBlockState(pos);
//                    if (!blockStatex.isAir()) {
//                        float g = ((BlockAccess)blockStatex).dualWielding$getDestroyProgress(player, level, pos) * (j + 1);
//                        if (g >= 0.7F) {
//                            isDestroyingBlock = false;
//                            level.destroyBlockProgress(player.getId(), pos, -1);
//                            this.dualWielding$destroyAndAck(pos, sequence, "destroyed");
//                            return;
//                        }
//                        PlayerBlockBreakEvents.CANCELED.invoker().onBlockBreakCanceled(level, player, pos, blockStatex, level.getBlockEntity(pos));
//                        if (!hasDelayedDestroy) {
//                            isDestroyingBlock = false;
//                            hasDelayedDestroy = true;
//                            delayedDestroyPos = pos;
//                            delayedTickStart = destroyProgressStart;
//                        }
//                    }
//                }
//
//                dualWielding$debugLogging(pos, true, sequence, "stopped destroying");
//            } else if (action == Action.ABORT_DESTROY_BLOCK) {
//                isOffMine = false;
//                isDestroyingBlock = false;
//                if (!Objects.equals(destroyPos, pos)) {
//                    AmbidexterityMain.LOGGER.warn("Mismatch in destroy block pos: {} {}", destroyPos, pos);
//                    level.destroyBlockProgress(player.getId(), destroyPos, -1);
//                    dualWielding$debugLogging(pos, true, sequence, "aborted mismatched destroying");
//                }
//
//                level.destroyBlockProgress(player.getId(), pos, -1);
//                dualWielding$debugLogging(pos, true, sequence, "aborted destroying");
//            }
//        }
//    }

    @ModifyExpressionValue(
            method = "incrementDestroyProgress",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/level/block/state/BlockState;getDestroyProgress(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)F"
            )
    )
    private float destroyProgressReplacer2(float original, @Local(argsOnly = true) class_2338 pos, @Local(argsOnly = true) class_2680 blockState) {
        if (this.isOffhand()) return ((BlockAccess) blockState).dualWielding$getDestroyProgress(player, this.player.method_37908(), pos);
        return original;
    }
//    @Unique
//    public float dualWielding$incrementDestroyProgress(BlockState state, BlockPos pos, int startTick) {
//        int i = this.gameTicks - startTick;
//        float f = ((BlockAccess)state).dualWielding$getDestroyProgress(player, level, pos) * (i + 1);
//        int j = (int)(f * 10.0F);
//        if (j != lastSentState) {
//            this.level.destroyBlockProgress(player.getId(), pos, j);
//            this.lastSentState = j;
//        }
//        return f;
//    }

    @Unique
    public void dualWielding$destroyAndAck(class_2338 pos, int sequence, String reason) {
        boolean varHolder = ((LivingEntityAccess) player).isOffhand();
        ((LivingEntityAccess) player).offhand(true);
        spgm.method_21717(pos, sequence, reason);
        ((LivingEntityAccess) player).offhand(varHolder);
    }

//    @ModifyExpressionValue(
//            method = "destroyBlock",
//            at = @At(
//                    value = "INVOKE",
//                    target = "Lnet/minecraft/server/level/ServerPlayer;hasCorrectToolForDrops(Lnet/minecraft/world/level/block/state/BlockState;)Z"
//            )
//    )
//    private boolean hasCorrectToolForDrops(boolean original, @Local BlockState blockState) {
//        if (this.isOffhand()) return ((PlayerAccess)player).dualWielding$hasCorrectToolForDrops(blockState);
//        return original;
//    }
    
    @Unique
    private boolean isOffhand() {
        return ((LivingEntityAccess) player).isOffhand();
    }
    
    @Unique
    private void offhand(boolean val) {
        ((LivingEntityAccess) player).offhand(val);
    }
}
