package eva.ambidexterity.config;

import eva.ambidexterity.config.enums.BalanceMode;
import eva.ambidexterity.config.enums.DefaultBehavior;
import eva.ambidexterity.network.BalancePacket;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class AmbidexterityConfig {

//    private boolean slotShift = true;
    private boolean updateDefault = true;
    private BalanceMode mode = BalanceMode.PRETTY_MUCH_BALANCED;
    private double dualDamageFactor = 0.8;
    private double twoHandedDamageFactor = 1.2;
    private double oneHandedDamageFactor = 1.0;
    private double dualSpeedFactor = 0.8;
    private double twoHandedSpeedFactor = 1.2;
    private double oneHandedSpeedFactor = 1.0;
    private DefaultBehavior defaultBehavior = DefaultBehavior.USE;
    private final List<String> invertList = new ArrayList<>();
    private boolean invertWithCrouch = true;
    {invertList.addAll(def());}
    private boolean toggleInvert = false;

    private static final Set<class_2960> invertItems = ConcurrentHashMap.newKeySet();
    private static AmbidexterityConfig INSTANCE;
    private static AmbidexterityConfig SERVER_INSTANCE;

    public static AmbidexterityConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AmbidexterityConfig();
        }
        return INSTANCE;
    }

    public static AmbidexterityConfig getServerInstance() {
        return SERVER_INSTANCE;
    }

    void updateConfigs(AmbidexterityConfig config) {
//        this.slotShift = config.slotShift;
        this.updateDefault = config.updateDefault;
        this.invertWithCrouch = config.invertWithCrouch;
        this.toggleInvert = config.toggleInvert;
        this.defaultBehavior = config.defaultBehavior;
        this.invertList.addAll(config.invertList);
        this.mode = config.mode;
        this.dualDamageFactor = config.dualDamageFactor;
        this.twoHandedDamageFactor = config.twoHandedDamageFactor;
        this.oneHandedDamageFactor = config.oneHandedDamageFactor;
        this.dualSpeedFactor =  config.dualSpeedFactor;
        this.twoHandedSpeedFactor = config.twoHandedSpeedFactor;
        this.oneHandedSpeedFactor = config.oneHandedSpeedFactor;
        if (updateDefault) {
            if (defaultBehavior == DefaultBehavior.ATTACK) defaultBehavior = DefaultBehavior.USE;
            updateDefault = false;
        }
    }

    public double[] getValues() {
        return new double[]{
                dualDamageFactor,
                oneHandedDamageFactor,
                twoHandedDamageFactor,
                dualSpeedFactor,
                oneHandedSpeedFactor,
                twoHandedSpeedFactor
        };
    }

    public static void onBalanceReceived(BalancePacket payload) {
        SERVER_INSTANCE.mode = payload.mode();
        if (SERVER_INSTANCE.getMode() == BalanceMode.CUSTOM_BALANCE) {
            double[] values = payload.values();
            SERVER_INSTANCE.dualDamageFactor = values[0];
            SERVER_INSTANCE.oneHandedDamageFactor = values[1];
            SERVER_INSTANCE.twoHandedDamageFactor = values[2];
            SERVER_INSTANCE.dualSpeedFactor = values[3];
            SERVER_INSTANCE.oneHandedSpeedFactor = values[4];
            SERVER_INSTANCE.twoHandedSpeedFactor = values[5];
        }
    }

    public DefaultBehavior getDefaultBehavior() {
        return defaultBehavior;
    }

    static void setDefaultBehavior(DefaultBehavior defaultBehavior) {
        getInstance().defaultBehavior = defaultBehavior;
    }

    public BalanceMode getMode() {
        return mode;
    }
    static void setMode(BalanceMode mode) {
        getInstance().mode = mode;
    }

    double getDualDamageFactor() {
        return dualDamageFactor;
    }
    static void setDualDamageFactor(double dualFactor) {
        getInstance().dualDamageFactor = dualFactor;
    }

    double getTwoHandedDamageFactor() {
        return twoHandedDamageFactor;
    }
    static void setTwoHandedDamageFactor(double twoHandedFactor) {
        getInstance().twoHandedDamageFactor = twoHandedFactor;
    }

    double getOneHandedDamageFactor() {
        return oneHandedDamageFactor;
    }
    static void setOneHandedDamageFactor(double oneHandedFactor) {
        getInstance().oneHandedDamageFactor = oneHandedFactor;
    }

    double getDualSpeedFactor() {
        return this.dualSpeedFactor;
    }
    static void setDualSpeedFactor(double dualSpeedFactor) {
        getInstance().dualSpeedFactor = dualSpeedFactor;
    }

    double getTwoHandedSpeedFactor() {
        return this.twoHandedSpeedFactor;
    }
    static void setTwoHandedSpeedFactor(double twoHandedSpeedFactor) {
        getInstance().twoHandedSpeedFactor = twoHandedSpeedFactor;
    }

    double getOneHandedSpeedFactor() {
        return this.oneHandedSpeedFactor;
    }
    static void setOneHandedSpeedFactor(double oneHandedSpeedFactor) {
        getInstance().oneHandedSpeedFactor = oneHandedSpeedFactor;
    }

    static List<String> getInvertList() {
        return new ArrayList<>(getInstance().invertList);
    }

    static void setInvertList(List<String> invertList) {
        getInstance().invertList.clear();
        getInstance().invertList.addAll(invertList);
        invertItems.clear();
        for (String name : invertList) {
            invertItems.add(class_2960.method_60654(name));
        }
    }

    static Set<class_2960> getInvertItems() {
        return new HashSet<>(invertItems);
    }

    public static boolean isInvertWithCrouch() {
        return getInstance().invertWithCrouch;
    }

    public static void setInvertWithCrouch(boolean invertWithCrouch) {
        getInstance().invertWithCrouch = invertWithCrouch;
    }

    public static boolean isToggleInvert() {
        return getInstance().toggleInvert;
    }

    public static void setToggleInvert(boolean toggleInvert) {
        getInstance().toggleInvert = toggleInvert;
    }

//    public static boolean isSlotShift() {
//        return getInstance().slotShift;
//    }
//
//    public static void setSlotShift(boolean slotShift) {
//        getInstance().slotShift = slotShift;
//    }

    private static class ErrorSupplier implements Function<String, Optional<class_2561>> {
        @Override
        public Optional<class_2561> apply(String entry) {
            entry = entry.toLowerCase();
            if (entry.indexOf(':') != entry.lastIndexOf(':'))
                return Optional.of(class_2561.method_43470("Enter a valid item TYPE! error code: 1"));
            String name = entry.substring(entry.indexOf(':') + 1).replaceAll("[^a-z0-9/._-]", "");
            if (!entry.equals(name)) {
                if (entry.indexOf(':') == -1)
                    return Optional.of(class_2561.method_43470("Enter a valid item TYPE! error code: 2"));
                String namespace = entry.substring(0,entry.indexOf(':')).replaceAll("[^a-z0-9/._-]", "");
                if (!entry.equals(namespace + ":" + name)) {
                    return Optional.of(class_2561.method_43470("Enter a valid item TYPE! error code: 3"));
                }
            }
            class_2960 id = class_2960.method_60654(entry);
            if (!class_7923.field_41178.method_10235().contains(id))
                return Optional.of(class_2561.method_43470("Enter a valid item TYPE! error code: 4"));
            return Optional.empty();
        }
    }
    static Function<String, Optional<class_2561>> getErrorSupplier() {
        return new ErrorSupplier();
    }

    public static void disconnect() {
        if (SERVER_INSTANCE != null)
            SERVER_INSTANCE = null;
    }

    static List<String> def() {
        List<String> temp = new ArrayList<>();
        temp.add("minecraft:air");
        return temp;
    }



}
