package eva.ambidexterity.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import eva.ambidexterity.access.LivingEntityAccess;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import net.minecraft.class_759;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(EnvType.CLIENT)
@Mixin(class_759.class)
public class ItemInHandRendererMixin {
    @Shadow private float offHandHeight;
    @Shadow @Final @Mutable private class_310 minecraft;
    @Shadow private class_1799 offHandItem;
    @Shadow private class_1799 mainHandItem;

    @Unique
    private boolean isOffhandAttack;
    @Unique
    class_1799 itemStack2;

    @Inject(method ="tick",
            at = @At(value = "FIELD",
                    target = "Lnet/minecraft/client/renderer/ItemInHandRenderer;offHandItem:Lnet/minecraft/world/item/ItemStack;",
                    opcode = Opcodes.PUTFIELD,
                    shift = At.Shift.BY))
    private void thief(CallbackInfo ci, @Local class_746 cpe){
        this.itemStack2 = cpe.method_6079();
        this.offHandItem = this.itemStack2;
    }

    @ModifyExpressionValue(method = "tick",
            at = @At(value = "INVOKE",
                    target = "Lnet/minecraft/util/Mth;clamp(FFF)F",
                    ordinal = 3))
    public float modifyH(float original) {
        assert minecraft.field_1724 != null;
        boolean valHolder = ((LivingEntityAccess) this.minecraft.field_1724).offhand(true);
        float o = minecraft.field_1724.method_7261(1.0F);
        if (o < 0.1F) {
            this.isOffhandAttack = true;
        }
        if (this.isOffhandAttack) {
            if (o >= 1.0F) {
                this.isOffhandAttack = false;
            }
            float h = this.offHandItem != itemStack2 ? 0.0F : o * o * o;
            ((LivingEntityAccess) this.minecraft.field_1724).offhand(false);
            return class_3532.method_15363(h - this.offHandHeight, -0.4F, 0.4F);
        }
        ((LivingEntityAccess) this.minecraft.field_1724).offhand(valHolder);
        return original;
    }

    @ModifyExpressionValue(
            method = "renderArmWithItem",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/world/InteractionHand;MAIN_HAND:Lnet/minecraft/world/InteractionHand;"
            )
    )
    private class_1268 alwaysShowBothHands(class_1268 original, @Local(argsOnly = true) class_1268 hand) {
        return hand;
    }

    @ModifyExpressionValue(
            method = "renderArmWithItem",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/client/renderer/ItemInHandRenderer;offHandItem:Lnet/minecraft/world/item/ItemStack;"
            )
    )
    private class_1799 mapStuff(class_1799 original, @Local(argsOnly = true) class_1268 hand) {
        if (hand == class_1268.field_5810) return mainHandItem;
        return original;
    }

    @ModifyVariable(
            method = "renderArmWithItem",
            at = @At(
                    value = "INVOKE",
                    target = "Lcom/mojang/blaze3d/vertex/PoseStack;pushPose()V"
            ),
            index = 12
    )
    private class_1306 armFix(class_1306 value, @Local(argsOnly = true) class_1268 hand) {
        if (hand == class_1268.field_5810) return value.method_5928();
        return value;
    }
}
