package eva.ambidexterity.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eva.ambidexterity.AmbidexterityClient;

import java.io.*;
import java.nio.file.Files;
import java.nio.file.Path;

public class JsonConfigHelper {
    private static final File folder = new File("config");
    private static File ambidexterityConfig;
    public static Gson configGson = new GsonBuilder().setPrettyPrinting().create();
    private static boolean convert = false;
    private static File simplyDualWieldingConfig;

    public static void init() {
        createConfig();
        readFromConfig();
        writeToConfig();
    }

    public static void createConfig() {
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (folder.isDirectory()) {
            ambidexterityConfig = new File(folder, "ambidexterity.json");
            boolean seemsValid;
            if (ambidexterityConfig.exists()) {
                try {
                    String ambidexterityConfigJson = Files.readString(Path.of(ambidexterityConfig.getPath()));
                    seemsValid = ambidexterityConfigJson.trim().startsWith("{");
                } catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                simplyDualWieldingConfig =  new File(folder, "simplydualwielding.json");
                if (simplyDualWieldingConfig.exists()) {
                    convert = true;
                }
                seemsValid = true;
            }
            if (!ambidexterityConfig.exists() || !seemsValid) {
                if (!seemsValid) {
                    AmbidexterityClient.LOGGER.info("Found invalid config file, creating new config file at './config/moreshieldvariants.json'.");
                }
                try {
                    ambidexterityConfig.createNewFile();
                    String json = configGson.toJson(AmbidexterityConfig.getInstance());
                    FileWriter writer = new FileWriter(ambidexterityConfig);
                    writer.write(json);
                    writer.close();
                } catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

        }
    }

    public static void readFromConfig() {
        try {
            AmbidexterityConfig config;
            if (convert) {
                config = configGson.fromJson(new FileReader(simplyDualWieldingConfig), AmbidexterityConfig.class);
            } else {
                config = configGson.fromJson(new FileReader(ambidexterityConfig), AmbidexterityConfig.class);
            }
            AmbidexterityConfig.getInstance().updateConfigs(config);
        } catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }


    public static void writeToConfig() {
        try {
            String json = configGson.toJson(AmbidexterityConfig.getInstance());
            FileWriter writer = new FileWriter(ambidexterityConfig, false);
            writer.write(json);
            writer.close();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}