package eva.ambidexterity.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import eva.ambidexterity.access.*;
import net.minecraft.class_1268;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2846;
import net.minecraft.class_2868;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3244.class)
public class ServerGamePacketListenerImplMixin {

    @Shadow
    public class_3222 player;

    @Inject(
            method = "handlePlayerAction",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/server/level/ServerPlayerGameMode;handleBlockBreakAction(Lnet/minecraft/core/BlockPos;Lnet/minecraft/network/protocol/game/ServerboundPlayerActionPacket$Action;Lnet/minecraft/core/Direction;II)V"
            ),
            cancellable = true
    )
    private void handlePlayerAction(class_2846 packet, CallbackInfo ci) {
        if (((ServerboundPlayerActionPacketAccess) packet).getOffhanded()) {
            ((ServerPlayerGameModeAccess) this.player.field_13974).dualWielding$handleBlockBreakAction(
                    packet.method_12362(),
                    packet.method_12363(),
                    packet.method_12360(),
                    this.player.method_37908().method_31600(),
                    packet.method_42079()
            );
            ((class_3244)(Object) this).method_41255(packet.method_42079());
            ci.cancel();
        }
    }

    @Inject(
            method = "handlePlayerAction",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/server/level/ServerPlayer;getItemInHand(Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/item/ItemStack;",
                    ordinal = 0
            ),
            cancellable = true
    )
    private void fixNegativeSwap(class_2846 packet, CallbackInfo ci) {
        if (((InventoryAccess) this.player.method_31548()).getOffSelectedSlot() == this.player.method_31548().method_67532()) {
            ((InventoryAccess) this.player.method_31548()).doHandSwap();
            ci.cancel();
        }
    }

    @Redirect(
            method = "handleSetCarriedItem",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Inventory;getSelectedSlot()I"
            )
    )
    private int getSelectedSlot(class_1661 inventory, @Local(argsOnly = true) class_2868 packet) {
        if (((ServerboundSetCarriedItemPacketAccess) packet).getOffhanded()) return ((InventoryAccess) inventory).getOffSelectedSlot();
        return inventory.method_67532();
    }

    @ModifyExpressionValue(
            method = "handleSetCarriedItem",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/world/InteractionHand;MAIN_HAND:Lnet/minecraft/world/InteractionHand;"
            )
    )
    private class_1268 hand(class_1268 original, @Local(argsOnly = true) class_2868 packet) {
        if (((ServerboundSetCarriedItemPacketAccess) packet).getOffhanded()) return class_1268.field_5810;
        return original;
    }

    @Redirect(
            method = "handleSetCarriedItem",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Inventory;setSelectedSlot(I)V"
            )
    )
    private void setSelectedSlot(class_1661 inventory, int slot, @Local(argsOnly = true) class_2868 packet) {
        if (((ServerboundSetCarriedItemPacketAccess) packet).getOffhanded()) ((InventoryAccess) inventory).setOffSelectedSlot(slot);
        else inventory.method_61496(slot);
    }

    @Redirect(
            method = "tryPickItem",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Inventory;setSelectedSlot(I)V"
            )
    )
    private void setSlot(class_1661 inventory, int slot) {
        if (((ServerPlayerAccess) this.player).isHotOffhand()) ((InventoryAccess) inventory).setOffSelectedSlot(slot);
        else inventory.method_61496(slot);
    }

    @Redirect(
            method = "tryPickItem",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Inventory;pickSlot(I)V"
            )
    )
    private void pickSlot(class_1661 inventory, int slot) {
        if (((ServerPlayerAccess) this.player).isHotOffhand()) ((InventoryAccess) inventory).pickOffSlot(slot);
        else inventory.method_61496(slot);
    }

    @Redirect(
            method = "tryPickItem",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Inventory;addAndPickItem(Lnet/minecraft/world/item/ItemStack;)V"
            )
    )
    private void addAndPickItem(class_1661 inventory, class_1799 stack) {
        if (((ServerPlayerAccess) this.player).isHotOffhand()) ((InventoryAccess) inventory).addAndPickOffItem(stack);
        else inventory.method_65126(stack);
    }

    @Redirect(
            method = "tryPickItem",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Inventory;getSelectedSlot()I"
            )
    )
    private int getSlot(class_1661 inventory) {
        if (((ServerPlayerAccess) this.player).isHotOffhand()) return ((InventoryAccess) inventory).getOffSelectedSlot();
        else return inventory.method_67532();
    }
}
