package eva.ambidexterity.mixin;

import eva.ambidexterity.access.LivingEntityAccess;
import eva.ambidexterity.config.ConfigInterpreter;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_5131;
import net.minecraft.class_5135;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin implements LivingEntityAccess {

    @Final @Shadow private class_5131 attributes;

    @Unique private boolean isOffhand = false;

    @Unique private class_5131 offhandAttributes;

    @Unique
    public boolean isOffhand() {
        return this.isOffhand;
    }

    @Override
    public boolean offhand(boolean isOffhand) {
        boolean bl = this.isOffhand;
        this.isOffhand = isOffhand;
        return bl;
    }

    @Inject(
            method = "<init>",
            at = @At("TAIL")
    )
    private void init(class_1299<? extends class_1309> entityType, class_1937 level, CallbackInfo ci) {
        this.offhandAttributes = new class_5131(class_5135.method_26873(entityType));
        if ((class_1309) (Object) this instanceof class_1657)
            offhandAttributeSetter((class_1657) (Object) this);
    }

    @Inject(
            method = "collectEquipmentChanges",
            at = @At("TAIL")
    )
    private void offhandItemChangedSomehowIdkHow(
            CallbackInfoReturnable<Map<class_1304, class_1799>> cir
    ) {
        if (((class_1309) (Object) this) instanceof class_1657)
            offhandAttributeSetter((class_1657) (Object) this);
    }

    @Unique
    private void offhandAttributeSetter(class_1657 player) {
        ConfigInterpreter.handFixer(player);
        class_1799 off;
        try {
            off = player.method_6079();
        }
        catch (NullPointerException exception) {
            off = class_1799.field_8037;
        }
        offhandAttributes = attributes;
        off.method_57354(class_1304.field_6173, (holder, attributeModifier) -> {
            class_1324 attributeInstance = this.offhandAttributes.method_45329(holder);
            if (attributeInstance != null) {
                attributeInstance.method_6200(attributeModifier.comp_2447());
                attributeInstance.method_26835(attributeModifier);
            }
        });
    }

    @Override
    public class_5131 offhandAttributes() {
        return offhandAttributes;
    }

}