package eva.ambidextrous.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eva.ambidextrous.AmbidextrousClient;

import java.io.*;
import java.nio.file.Files;
import java.nio.file.Path;

public class JsonConfigHelper {
    private static final File folder = new File("config");
    private static File ambidextrousConfig;
    public static Gson configGson = new GsonBuilder().setPrettyPrinting().create();
    private static boolean convert = false;
    private static File simplyDualWieldingConfig;

    public static void init() {
        createConfig();
        readFromConfig();
        writeToConfig();
    }

    public static void createConfig() {
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (folder.isDirectory()) {
            ambidextrousConfig = new File(folder, "ambidextrous.json");
            boolean seemsValid;
            if (ambidextrousConfig.exists()) {
                try {
                    String ambidextrousConfigJson = Files.readString(Path.of(ambidextrousConfig.getPath()));
                    seemsValid = ambidextrousConfigJson.trim().startsWith("{");
                } catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                simplyDualWieldingConfig =  new File(folder, "simplydualwielding.json");
                if (simplyDualWieldingConfig.exists()) {
                    convert = true;
                }
                seemsValid = true;
            }
            if (!ambidextrousConfig.exists() || !seemsValid) {
                if (!seemsValid) {
                    AmbidextrousClient.LOGGER.info("Found invalid config file, creating new config file at './config/moreshieldvariants.json'.");
                }
                try {
                    ambidextrousConfig.createNewFile();
                    String json = configGson.toJson(AmbidextrousConfig.getInstance());
                    FileWriter writer = new FileWriter(ambidextrousConfig);
                    writer.write(json);
                    writer.close();
                } catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

        }
    }

    public static void readFromConfig() {
        try {
            AmbidextrousConfig config;
            if (convert) {
                config = configGson.fromJson(new FileReader(simplyDualWieldingConfig), AmbidextrousConfig.class);
            } else {
                config = configGson.fromJson(new FileReader(ambidextrousConfig), AmbidextrousConfig.class);
            }
            AmbidextrousConfig.getInstance().updateConfigs(config);
        } catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }


    public static void writeToConfig() {
        try {
            String json = configGson.toJson(AmbidextrousConfig.getInstance());
            FileWriter writer = new FileWriter(ambidextrousConfig, false);
            writer.write(json);
            writer.close();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}