package eva.ambidextrous.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import eva.ambidextrous.access.EntityEquipmentAccess;
import eva.ambidextrous.access.LivingEntityAccess;
import eva.ambidextrous.config.ConfigInterpreter;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Map;
import net.minecraft.class_10630;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_5131;
import net.minecraft.class_5135;

@Mixin(class_1309.class)
public class LivingEntityMixin implements LivingEntityAccess {

    @Final @Shadow private class_5131 attributes;

    @Shadow @Final protected class_10630 equipment;

    @Unique private class_5131 offhandAttributes;

    @Unique
    public boolean isOffhand() {
        return ((EntityEquipmentAccess) this.equipment).isOffhand();
    }

    @Inject(
            method = "<init>",
            at = @At("TAIL")
    )
    private void init(class_1299<? extends class_1309> entityType, class_1937 level, CallbackInfo ci) {
        this.offhandAttributes = new class_5131(class_5135.method_26873(entityType));
        if ((class_1309) (Object) this instanceof class_1657)
            offhandAttributeSetter((class_1657) (Object) this);
    }

    @Inject(
            method = "getItemBySlot",
            at = @At("HEAD"),
            cancellable = true
    )
    private void mainHandStackChanger1(CallbackInfoReturnable<class_1799> cir, @Local(argsOnly = true) class_1304 slot) {
        if (slot.equals(class_1304.field_6173) && isOffhand()) {
            cir.setReturnValue(((class_1309) (Object) this).method_6079());
            cir.cancel();
        }
    }

    @Inject(
            method = "collectEquipmentChanges",
            at = @At("TAIL")
    )
    private void offhandItemChangedSomehowIdkHow(
            CallbackInfoReturnable<Map<class_1304, class_1799>> cir
    ) {
        if (((class_1309) (Object) this) instanceof class_1657)
            offhandAttributeSetter((class_1657) (Object) this);
    }

    @Unique
    private void offhandAttributeSetter(class_1657 player) {
        ConfigInterpreter.handFixer(player);
        class_1799 off;
        try {
            off = player.method_6079();
        }
        catch (NullPointerException exception) {
            off = class_1799.field_8037;
        }
        offhandAttributes = attributes;
        off.method_57354(class_1304.field_6173, (holder, attributeModifier) -> {
            class_1324 attributeInstance = this.offhandAttributes.method_45329(holder);
            if (attributeInstance != null) {
                attributeInstance.method_6200(attributeModifier.comp_2447());
                attributeInstance.method_26835(attributeModifier);
            }
        });
    }

    @Override
    public boolean offhand(boolean isOffHand) {
        return ((EntityEquipmentAccess) this.equipment).offhand(isOffHand);
    }

    @Override
    public class_5131 offhandAttributes() {
        return offhandAttributes;
    }

}