package eva.ambidextrous.mixin;

import eva.ambidextrous.access.ServerboundPlayerActionPacketAccess;
import net.minecraft.class_2540;
import net.minecraft.class_2846;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_2846.class)
public class ServerboundPlayerActionPacketMixin implements ServerboundPlayerActionPacketAccess {
    @Unique
    private boolean offhanded = false;

    @Inject(
            method = "<init>(Lnet/minecraft/network/FriendlyByteBuf;)V",
            at = @At(
                    value = "TAIL"
            )
    )
    private void readBuf(class_2540 buffer, CallbackInfo ci) {
        this.offhanded = buffer.readBoolean();
    }

    @Inject(
            method = "write",
            at = @At(
                    value = "TAIL"
            )
    )
    private void writeBuf(class_2540 buffer, CallbackInfo ci) {
        buffer.method_52964(this.offhanded);
    }

    @Unique
    public void setOffhanded(boolean offhanded) {
        this.offhanded = offhanded;
    }

    @Unique
    public boolean getOffhanded() {
        return this.offhanded;
    }

}
