/*
 * Decompiled with CFR 0.152.
 */
package eva.ambidextrous.config;

import eva.ambidextrous.config.enums.BalanceMode;
import eva.ambidextrous.config.enums.DefaultBehavior;
import eva.ambidextrous.network.BalancePacket;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class AmbidextrousConfig {
    private BalanceMode mode = BalanceMode.PRETTY_MUCH_BALANCED;
    private double dualDamageFactor = 0.8;
    private double twoHandedDamageFactor = 1.2;
    private double oneHandedDamageFactor = 1.0;
    private double dualSpeedFactor = 0.8;
    private double twoHandedSpeedFactor = 1.2;
    private double oneHandedSpeedFactor = 1.0;
    private DefaultBehavior defaultBehavior = DefaultBehavior.ATTACK;
    private final List<String> invertList = new ArrayList<String>();
    private boolean invertWithCrouch = true;
    private static final Set<class_2960> invertItems = ConcurrentHashMap.newKeySet();
    private static AmbidextrousConfig INSTANCE;
    private static AmbidextrousConfig SERVER_INSTANCE;

    public AmbidextrousConfig() {
        this.invertList.addAll(AmbidextrousConfig.def());
    }

    public static AmbidextrousConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AmbidextrousConfig();
        }
        return INSTANCE;
    }

    public static AmbidextrousConfig getServerInstance() {
        return SERVER_INSTANCE;
    }

    void updateConfigs(AmbidextrousConfig config) {
        this.defaultBehavior = config.defaultBehavior;
        this.invertList.addAll(config.invertList);
        this.mode = config.mode;
        this.dualDamageFactor = config.dualDamageFactor;
        this.twoHandedDamageFactor = config.twoHandedDamageFactor;
        this.oneHandedDamageFactor = config.oneHandedDamageFactor;
        this.dualSpeedFactor = config.dualSpeedFactor;
        this.twoHandedSpeedFactor = config.twoHandedSpeedFactor;
        this.oneHandedSpeedFactor = config.oneHandedSpeedFactor;
    }

    public double[] getValues() {
        return new double[]{this.dualDamageFactor, this.oneHandedDamageFactor, this.twoHandedDamageFactor, this.dualSpeedFactor, this.oneHandedSpeedFactor, this.twoHandedSpeedFactor};
    }

    public static void onBalanceReceived(BalancePacket payload) {
        AmbidextrousConfig.SERVER_INSTANCE.mode = payload.mode();
        if (SERVER_INSTANCE.getMode() == BalanceMode.CUSTOM_BALANCE) {
            double[] values = payload.values();
            AmbidextrousConfig.SERVER_INSTANCE.dualDamageFactor = values[0];
            AmbidextrousConfig.SERVER_INSTANCE.oneHandedDamageFactor = values[1];
            AmbidextrousConfig.SERVER_INSTANCE.twoHandedDamageFactor = values[2];
            AmbidextrousConfig.SERVER_INSTANCE.dualSpeedFactor = values[3];
            AmbidextrousConfig.SERVER_INSTANCE.oneHandedSpeedFactor = values[4];
            AmbidextrousConfig.SERVER_INSTANCE.twoHandedSpeedFactor = values[5];
        }
    }

    public DefaultBehavior getDefaultBehavior() {
        return this.defaultBehavior;
    }

    static void setDefaultBehavior(DefaultBehavior defaultBehavior) {
        AmbidextrousConfig.getInstance().defaultBehavior = defaultBehavior;
    }

    public BalanceMode getMode() {
        return this.mode;
    }

    static void setMode(BalanceMode mode) {
        AmbidextrousConfig.getInstance().mode = mode;
    }

    double getDualDamageFactor() {
        return this.dualDamageFactor;
    }

    static void setDualDamageFactor(double dualFactor) {
        AmbidextrousConfig.getInstance().dualDamageFactor = dualFactor;
    }

    double getTwoHandedDamageFactor() {
        return this.twoHandedDamageFactor;
    }

    static void setTwoHandedDamageFactor(double twoHandedFactor) {
        AmbidextrousConfig.getInstance().twoHandedDamageFactor = twoHandedFactor;
    }

    double getOneHandedDamageFactor() {
        return this.oneHandedDamageFactor;
    }

    static void setOneHandedDamageFactor(double oneHandedFactor) {
        AmbidextrousConfig.getInstance().oneHandedDamageFactor = oneHandedFactor;
    }

    double getDualSpeedFactor() {
        return this.dualSpeedFactor;
    }

    static void setDualSpeedFactor(double dualSpeedFactor) {
        AmbidextrousConfig.getInstance().dualSpeedFactor = dualSpeedFactor;
    }

    double getTwoHandedSpeedFactor() {
        return this.twoHandedSpeedFactor;
    }

    static void setTwoHandedSpeedFactor(double twoHandedSpeedFactor) {
        AmbidextrousConfig.getInstance().twoHandedSpeedFactor = twoHandedSpeedFactor;
    }

    double getOneHandedSpeedFactor() {
        return this.oneHandedSpeedFactor;
    }

    static void setOneHandedSpeedFactor(double oneHandedSpeedFactor) {
        AmbidextrousConfig.getInstance().oneHandedSpeedFactor = oneHandedSpeedFactor;
    }

    static List<String> getInvertList() {
        return new ArrayList<String>(AmbidextrousConfig.getInstance().invertList);
    }

    static void setInvertList(List<String> invertList) {
        AmbidextrousConfig.getInstance().invertList.clear();
        AmbidextrousConfig.getInstance().invertList.addAll(invertList);
        invertItems.clear();
        for (String name : invertList) {
            invertItems.add(class_2960.method_60654((String)name));
        }
    }

    static Set<class_2960> getInvertItems() {
        return new HashSet<class_2960>(invertItems);
    }

    public static boolean isInvertWithCrouch() {
        return AmbidextrousConfig.getInstance().invertWithCrouch;
    }

    public static void setInvertWithCrouch(boolean invertWithCrouch) {
        AmbidextrousConfig.getInstance().invertWithCrouch = invertWithCrouch;
    }

    static Function<String, Optional<class_2561>> getErrorSupplier() {
        return new ErrorSupplier();
    }

    public static void disconnect() {
        if (SERVER_INSTANCE != null) {
            SERVER_INSTANCE = null;
        }
    }

    static List<String> def() {
        return List.of("minecraft:air");
    }

    private static class ErrorSupplier
    implements Function<String, Optional<class_2561>> {
        private ErrorSupplier() {
        }

        @Override
        public Optional<class_2561> apply(String entry) {
            if ((entry = entry.toLowerCase()).indexOf(58) != entry.lastIndexOf(58)) {
                return Optional.of(class_2561.method_43470((String)"Enter a valid item TYPE! error code: 1"));
            }
            String name = entry.substring(entry.indexOf(58) + 1).replaceAll("[^a-z0-9/._-]", "");
            if (!entry.equals(name)) {
                if (entry.indexOf(58) == -1) {
                    return Optional.of(class_2561.method_43470((String)"Enter a valid item TYPE! error code: 2"));
                }
                String namespace = entry.substring(0, entry.indexOf(58)).replaceAll("[^a-z0-9/._-]", "");
                if (!entry.equals(namespace + ":" + name)) {
                    return Optional.of(class_2561.method_43470((String)"Enter a valid item TYPE! error code: 3"));
                }
            }
            class_2960 id = class_2960.method_60654((String)entry);
            if (!class_7923.field_41178.method_10235().contains(id)) {
                return Optional.of(class_2561.method_43470((String)"Enter a valid item TYPE! error code: 4"));
            }
            return Optional.empty();
        }
    }
}

