/*
 * Decompiled with CFR 0.152.
 */
package eva.ambidextrous.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eva.ambidextrous.AmbidextrousClient;
import eva.ambidextrous.config.AmbidextrousConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;

public class JsonConfigHelper {
    private static final File folder = new File("config");
    private static File ambidextrousConfig;
    public static Gson configGson;
    private static boolean convert;
    private static File simplyDualWieldingConfig;

    public static void init() {
        JsonConfigHelper.createConfig();
        JsonConfigHelper.readFromConfig();
        JsonConfigHelper.writeToConfig();
    }

    public static void createConfig() {
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (folder.isDirectory()) {
            boolean seemsValid;
            ambidextrousConfig = new File(folder, "ambidextrous.json");
            if (ambidextrousConfig.exists()) {
                try {
                    String ambidextrousConfigJson = Files.readString(Path.of(ambidextrousConfig.getPath(), new String[0]));
                    seemsValid = ambidextrousConfigJson.trim().startsWith("{");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                simplyDualWieldingConfig = new File(folder, "simplydualwielding.json");
                if (simplyDualWieldingConfig.exists()) {
                    convert = true;
                }
                seemsValid = true;
            }
            if (!ambidextrousConfig.exists() || !seemsValid) {
                if (!seemsValid) {
                    AmbidextrousClient.LOGGER.info("Found invalid config file, creating new config file at './config/moreshieldvariants.json'.");
                }
                try {
                    ambidextrousConfig.createNewFile();
                    String json = configGson.toJson((Object)AmbidextrousConfig.getInstance());
                    FileWriter writer = new FileWriter(ambidextrousConfig);
                    writer.write(json);
                    writer.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static void readFromConfig() {
        try {
            AmbidextrousConfig config = convert ? (AmbidextrousConfig)configGson.fromJson((Reader)new FileReader(simplyDualWieldingConfig), AmbidextrousConfig.class) : (AmbidextrousConfig)configGson.fromJson((Reader)new FileReader(ambidextrousConfig), AmbidextrousConfig.class);
            AmbidextrousConfig.getInstance().updateConfigs(config);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeToConfig() {
        try {
            String json = configGson.toJson((Object)AmbidextrousConfig.getInstance());
            FileWriter writer = new FileWriter(ambidextrousConfig, false);
            writer.write(json);
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        configGson = new GsonBuilder().setPrettyPrinting().create();
        convert = false;
    }
}

