package eva.ambidexterity.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import eva.ambidexterity.access.InventoryAccess;
import eva.ambidexterity.access.LivingEntityAccess;
import eva.ambidexterity.access.MultiPlayerGameModeAccess;
import eva.ambidexterity.access.PlayerAccess;
import eva.ambidexterity.network.AttackPayload;
import eva.ambidexterity.util.LastAct;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static eva.ambidexterity.AmbidexterityClient.handleTicker;
import static eva.ambidexterity.config.ConfigInterpreter.checkInversion;

@Environment(EnvType.CLIENT)
@Mixin(class_310.class)
public class MinecraftMixin {

    @Shadow @Nullable public class_746 player;
    @Shadow @Nullable public class_638 level;
    @Shadow private int rightClickDelay;

    @Shadow public int missTime;
    @Unique private int secondUseCooldown;

    @Unique private boolean held = false;
    @Unique private LastAct noSwap = LastAct.NULL;
    @Unique private final class_310 tMc = (class_310) (Object) this;

    @Unique private final class_1268[] actualHand = new class_1268[]{null};

    @Unique private boolean breaki = false;

    @Inject(method = "tick()V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/Minecraft;handleKeybinds()V"))
    private void tickTickTick(CallbackInfo ci) {
        if (this.secondUseCooldown > 0) --this.secondUseCooldown;
        if (missTime > 500) missTime = 10;
    }

    @Inject(
            method = "tick",
            at = @At("HEAD")
    )
    private void tickyTick(CallbackInfo ci) {
        held = false;
        breaki = false;
        handleTicker();
//        if (this.player != null) ((InventoryAccess) this.player.getInventory()).tick();
    }

    @Redirect(
            method = "startUseItem",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/InteractionHand;values()[Lnet/minecraft/world/InteractionHand;"
            )
    )
    private class_1268[] handArray() {
        return actualHand;
    }

    @Inject(
            method = "startUseItem",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/player/LocalPlayer;getItemInHand(Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/item/ItemStack;"
            ),
            cancellable = true
    )
    private void cancelIfMismatched(CallbackInfo ci, @Local class_1268 hand) {
        this.throwE(hand, ci);
    }

    @Inject(method = "startUseItem",
            at = @At(value = "INVOKE",
                    target = "Lnet/minecraft/world/InteractionResult$Success;swingSource()Lnet/minecraft/world/InteractionResult$SwingSource;"
            )
    )
    private void set(CallbackInfo ci) {
        noSwap = LastAct.USE;
    }

    @Inject(
            method = "startUseItem",
            at = @At("HEAD"),
            cancellable = true
    )
    private void keepMining(CallbackInfo ci) {
        if (noSwap == LastAct.ATTACK && held) {
            doUseHit(ci, actualHand[0]);
        }
    }

    @Inject(method = "startUseItem",
            at = @At(value = "INVOKE",
                    target = "Lnet/minecraft/client/player/LocalPlayer;getItemInHand(Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/item/ItemStack;"),
            cancellable = true)
    private void blockItemUseAction(CallbackInfo ci, @Local class_1268 hand) {
        throwE(hand, ci);
        assert player != null;
        if (checkInversion(player.method_5998(hand), hand)) {
            this.breaki = this.doUseHit(ci, hand, true);
        }
    }

    @Inject(
            method = "startUseItem",
            at = @At(
                    value = "RETURN",
                    shift = At.Shift.BY,
                    by = 2
            ),
            slice = @Slice(
                    from = @At(
                            value = "INVOKE",
                            target = "Lnet/minecraft/world/item/ItemStack;isEmpty()Z",
                            ordinal = 1
                    )
            ),
            cancellable = true
    )
    private void doUseHit(CallbackInfo ci, @Local class_1268 hand) {
        throwE(hand, ci);
        assert player != null;
        this.breaki = this.doUseHit(ci, hand, false);
    }

    @Unique
    private boolean doUseHit(@Nullable CallbackInfo ci, class_1268 hand, boolean skippedTo) {
        throwE(hand, ci);
        assert player != null;
        this.breaki = false;
        boolean bl2 = false;
        if (!held) /*if (skippedTo || tMc.hitResult instanceof BlockHitResult)*/
            if (!player.method_7325()) {
                // everything above this should remain in some form
                boolean varHolder = this.isOffhand();
                ((LivingEntityAccess) player).offhand(hand == class_1268.field_5810);
                bl2 = tMc.method_1536();
                ((LivingEntityAccess) player).offhand(varHolder);
            }
        if (ci != null) ci.cancel();
        return bl2;
    }

    @ModifyExpressionValue(
            method = "startAttack",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/client/Minecraft;missTime:I",
                    opcode = Opcodes.GETFIELD
            )
    )
    private int missTimeCheck(int original) {
        if (this.isOffhand())
            return this.secondUseCooldown;
        return original;
    }

    @Redirect(
            method = "startAttack",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/client/Minecraft;missTime:I",
                    opcode = Opcodes.PUTFIELD
            )
    )
    private void missTimeSet(class_310 mc, int original) {
        if (this.isOffhand())
            secondUseCooldown = original;
        else mc.field_1771 = original;
    }

    @ModifyExpressionValue(
            method = "startAttack",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/world/InteractionHand;MAIN_HAND:Lnet/minecraft/world/InteractionHand;"
            )
    )
    private class_1268 handReplacer(class_1268 original) {
        if (this.isOffhand())
            return class_1268.field_5810;
        return original;
    }

    @Inject(
            method = "startAttack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/phys/HitResult;getType()Lnet/minecraft/world/phys/HitResult$Type;",
                    shift = At.Shift.BEFORE
            )
    )
    private void noSwapper(CallbackInfoReturnable<Boolean> cir) {
        this.noSwap = LastAct.ATTACK;
    }

    @Redirect(
            method = "startAttack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;attack(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/entity/Entity;)V"
            )
    )
    private void attack(class_636 gameMode, class_1657 player, class_1297 targetEntity) {
        if (this.isOffhand()) {
            if (!held) {
                // Client
                ((PlayerAccess) player).dualWielding$attackOffhand(targetEntity);
                // Server
                ClientPlayNetworking.send(new AttackPayload(targetEntity.method_5628()));
            }
        }
        else gameMode.method_2918(player, targetEntity);
    }

    @Redirect(
            method = "startAttack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;startDestroyBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Z"
            )
    )
    private boolean blockDestroyStarter(class_636 gameMode, class_2338 blockPos, class_2350 face) {
        if (this.isOffhand()) {
            return ((MultiPlayerGameModeAccess) gameMode).dualWielding$startDestroyBlock(blockPos, face);
        }
        return gameMode.method_2910(blockPos, face);
    }

    @Inject(
            method = "startAttack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/player/LocalPlayer;swing(Lnet/minecraft/world/InteractionHand;)V"
            )
    )
    private void notHolding(CallbackInfoReturnable<Boolean> cir) {
        held = false;
    }

//    @Inject(
//            method = "continueAttack",
//            at = @At(
//                    value = "INVOKE",
//                    target = "Lnet/minecraft/world/phys/BlockHitResult;getBlockPos()Lnet/minecraft/core/BlockPos;"
//            )
//    )
//    private void setMiningMain(CallbackInfo ci) {
//        isMining = IsMining.MAIN;
//    }

    @Inject(
            method = "handleKeybinds",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/multiplayer/ClientPacketListener;send(Lnet/minecraft/network/protocol/Packet;)V"
            )
    )
    private void handleSwapper(CallbackInfo ci) {
        assert this.player != null;
        if (this.player.method_31548().method_67532() == ((InventoryAccess) this.player.method_31548()).getOffSelectedSlot()) {
            ((InventoryAccess) this.player.method_31548()).doHandSwap();
        }
    }

    @ModifyExpressionValue(
            method = "handleKeybinds",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/KeyMapping;isDown()Z",
                    ordinal = 2
            )
    )
    private boolean changeStopUseItem(boolean original) {
        return original || tMc.field_1690.field_1886.method_1434();
    }

    @Redirect(
            method = "handleKeybinds",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/KeyMapping;consumeClick()Z",
                    ordinal = 14
            )
    )
    private boolean no(class_304 instance) {
        return false;
    }

    @Redirect(
            method = "handleKeybinds",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/KeyMapping;consumeClick()Z",
                    ordinal = 15
            )
    )
    private boolean internalHandleKeybinds(class_304 instance) {
        if (tMc.field_1690.field_1886.method_1434())
            while (tMc.field_1690.field_1886.method_1436())
                this.startUseItem(class_1268.field_5808, tMc);
        if (tMc.field_1690.field_1904.method_1434())
            while (tMc.field_1690.field_1904.method_1436())
                this.startUseItem(class_1268.field_5810, tMc);
        return false;
    }

//    @Redirect(
//            method = "handleKeybinds",
//            at = @At(
//                    value = "INVOKE",
//                    target = "Lnet/minecraft/client/KeyMapping;isDown()Z",
//                    ordinal = 3
//            )
//    )
//    private boolean mappingChecker(KeyMapping instance) {
//        return instance.isDown() || tMc.options.keyAttack.isDown();
//    }

//    @ModifyExpressionValue(
//            method = "handleKeybinds",
//            at = @At(
//                    value = "INVOKE",
//                    target = "Lnet/minecraft/client/player/LocalPlayer;isUsingItem()Z",
//                    ordinal = 1
//            )
//    )
//    private boolean startAttackRedirector(boolean original) {
//        return false;
//    }

//    @Redirect(
//            method = "handleKeybinds",
//            at = @At(
//                    value = "INVOKE",
//                    target = "Lnet/minecraft/client/Minecraft;startUseItem()V",
//                    ordinal = 1
//            )
//    )
//    private void startUseItemRedirector2(Minecraft instance) {
//        held = true;
//        this.startUseItem(tMc.options.keyAttack.isDown() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, instance);
//    }

    @Unique
    private void startUseItem(class_1268 hand, class_310 instance) {
        this.actualHand[0] = hand;
        instance.method_1583();
        this.actualHand[0] = null;
    }

    @ModifyExpressionValue(
            method = "handleKeybinds",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/KeyMapping;isDown()Z",
                    ordinal = 3
            )
    )
    private boolean mainHandUse(boolean original) {
        return false;
    }

//    @Inject(
//            method = "handleKeybinds",
//            at = @At(
//                    value = "INVOKE",
//                    target = "Lnet/minecraft/client/Minecraft;continueAttack(Z)V"
//            )
//    )
//    private void offHandUse(CallbackInfo ci) {
//        assert tMc.player != null;
//        if (tMc.options.keyUse.isDown() && this.rightClickDelay == 0 && !tMc.player.isUsingItem()) {
//            held = true;
//            this.startUseItem(InteractionHand.OFF_HAND, tMc);
//        }
//    }

//    @Inject(
//            method = "handleKeybinds",
//            at = @At(
//                    value = "INVOKE",
//                    target = "Lnet/minecraft/client/Minecraft;continueAttack(Z)V"
//            )
//    )
//    private void handleBlockBreaking(CallbackInfo ci) {
//
//    }

    @Redirect(
            method = "handleKeybinds",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/Minecraft;continueAttack(Z)V"
            )
    )
    private void continueMining(class_310 instance, boolean leftClick) {
        assert this.player != null;
        held = true;
        boolean[] keys = {tMc.field_1690.field_1886.method_1434(), tMc.field_1690.field_1904.method_1434()};
        if ((keys[0] || keys[1]) && this.rightClickDelay == 0 && !this.player.method_6115()) {
            if (keys[0]) this.startUseItem(class_1268.field_5808, instance);
            if (keys[1]) this.startUseItem(class_1268.field_5810, instance);
        }
        assert tMc.field_1761 != null;
        if ((keys[0] || keys[1]) && noSwap != LastAct.USE) {
//        if (isMining == IsMining.OFF)
//            isMining = IsMining.NULL;
            if (keys[0])
                tMc.method_1590(tMc.field_1755 == null && !breaki && tMc.field_1729.method_1613());
//        if (isMining == IsMining.MAIN)
//            isMining = IsMining.NULL;
            else
                this.continueOffMine(tMc.field_1755 == null && !breaki && tMc.field_1729.method_1613());
        } else {
            tMc.field_1761.method_2925();
            ((MultiPlayerGameModeAccess) tMc.field_1761).dualWielding$stopDestroyBlock();
        }
    }

    @Unique
    private void continueOffMine(boolean breaking) {
        assert player != null;
        boolean varHolder = this.isOffhand();
        ((LivingEntityAccess) player).offhand(true);
        tMc.method_1590(breaking);
        ((LivingEntityAccess) player).offhand(varHolder);

    }

    @Redirect(
            method = "continueAttack",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/client/Minecraft;missTime:I",
                    ordinal = 0
            )
    )
    private void missTimeSET(class_310 instance, int value) {
        if (this.isOffhand()) secondUseCooldown = value;
        else instance.field_1771 = value;
    }

    @ModifyExpressionValue(
            method = "continueAttack",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/client/Minecraft;missTime:I",
                    ordinal = 1
            )
    )
    private int missTimeGET(int original) {
        if (this.isOffhand()) return secondUseCooldown;
        return original;
    }

    @Redirect(
            method = "continueAttack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;continueDestroyBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Z"
            )
    )
    private boolean executeContinueDestroyBlock(class_636 instance, class_2338 posBlock, class_2350 directionFacing) {
        if (this.isOffhand()) return ((MultiPlayerGameModeAccess) instance).dualWielding$continueDestroyBlock(posBlock, directionFacing);
        return instance.method_2902(posBlock, directionFacing);
    }

    @ModifyArg(
            method = "continueAttack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/player/LocalPlayer;swing(Lnet/minecraft/world/InteractionHand;)V"
            )
    )
    private class_1268 replaceMainHandArg(class_1268 hand) {
        if (this.isOffhand()) return class_1268.field_5810;
        return hand;
    }

    @Redirect(
            method = "continueAttack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;stopDestroyBlock()V"
            )
    )
    private void stopDestroyBlock(class_636 instance) {
        if (this.isOffhand())
            ((MultiPlayerGameModeAccess) instance).dualWielding$stopDestroyBlock();
        else instance.method_2925();
    }
    
    @Unique
    private boolean isOffhand() {
        assert player != null;
        return ((LivingEntityAccess) player).isOffhand();
    }

    @Unique
    private void throwE(class_1268 hand, @Nullable CallbackInfo ci) {
        if (hand != this.actualHand[0]) {
            if (ci != null) ci.cancel();
            throw new RuntimeException();
        }
    }
    
}