package eva.ambidexterity.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import eva.ambidexterity.access.InventoryAccess;
import eva.ambidexterity.access.LivingEntityAccess;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_759;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Environment(EnvType.CLIENT)
@Mixin(class_759.class)
public class ItemInHandRendererMixin {
    @Shadow @Final @Mutable private class_310 minecraft;
    @Shadow private class_1799 offHandItem;
    @Shadow private class_1799 mainHandItem;

//    @Unique
//    Boolean hasBobbed = null;

    @ModifyConstant(
            method = "tick",
            constant = @Constant(
                    floatValue = 1.0F,
                    ordinal = 3
            )
    )
    private float offhandF(float constant) {
        assert minecraft.field_1724 != null;
        boolean bl = ((LivingEntityAccess) this.minecraft.field_1724).offhand(true);
        float o = this.minecraft.field_1724.method_7261(1.0F);
        ((LivingEntityAccess) this.minecraft.field_1724).offhand(bl);
        return o * o * o;
    }

    @ModifyExpressionValue(
            method = "tick",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/renderer/ItemInHandRenderer;shouldInstantlyReplaceVisibleItem(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)Z"
            )
    )
    private boolean shouldNotReplaceInstantlyThanks(boolean original) {
        if (!original) return false;
        assert this.minecraft.field_1724 != null;
        return !((InventoryAccess) this.minecraft.field_1724.method_31548()).isSlotChanged();
    }


    @ModifyExpressionValue(
            method = "renderArmWithItem",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/world/InteractionHand;MAIN_HAND:Lnet/minecraft/world/InteractionHand;"
            )
    )
    private class_1268 alwaysShowBothHands(class_1268 original, @Local(argsOnly = true) class_1268 hand) {
        return hand;
    }

    @ModifyExpressionValue(
            method = "renderArmWithItem",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/player/AbstractClientPlayer;isInvisible()Z"
            )
    )
    private boolean twoHandMaps(boolean original, @Local(argsOnly = true) class_1268 hand, @Local(argsOnly = true) class_1799 itemStack) {
        if (original) return true;
        assert this.minecraft.field_1724 != null;
        return switch (hand) {
            case field_5808 -> offHandItem.method_57826(class_9334.field_49646);
            case field_5810 -> mainHandItem.method_57826(class_9334.field_49646);
        };
    }

    @ModifyExpressionValue(
            method = "renderTwoHandedMap",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/client/renderer/ItemInHandRenderer;mainHandItem:Lnet/minecraft/world/item/ItemStack;"
            )
    )
    private class_1799 bothHandsCanHaveMapsDidntYouKnow(class_1799 original) {
        if (original.method_57826(class_9334.field_49646)) return original;
        if (offHandItem.method_57826(class_9334.field_49646)) return offHandItem;
        throw new IllegalArgumentException();
    }

    @ModifyExpressionValue(
            method = "renderArmWithItem",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/client/renderer/ItemInHandRenderer;offHandItem:Lnet/minecraft/world/item/ItemStack;"
            )
    )
    private class_1799 mapStuff(class_1799 original, @Local(argsOnly = true) class_1268 hand) {
        return switch (hand) {
            case field_5808 -> original;
            case field_5810 -> mainHandItem;
        };
    }

    @ModifyVariable(
            method = "renderArmWithItem",
            at = @At(
                    value = "INVOKE",
                    target = "Lcom/mojang/blaze3d/vertex/PoseStack;pushPose()V"
            ),
            index = 12
    )
    private class_1306 armFix(class_1306 value, @Local(argsOnly = true) class_1268 hand) {
        if (hand == class_1268.field_5810) return value.method_5928();
        return value;
    }

}
