package eva.ambidexterity.mixin;

import com.google.common.collect.ImmutableList;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import eva.ambidexterity.access.InventoryAccess;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1275;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_9928;

import static eva.ambidexterity.AmbidexterityMain.isInverted;

@Mixin(class_1661.class)
public abstract class InventoryMixin implements class_1263, class_1275, InventoryAccess {

    @Shadow
    @Final
    @Mutable
    public static int SELECTION_SIZE;
    @Shadow
    @Final
    @Mutable
    public static int SLOT_OFFHAND;
    @Shadow
    @Final
    @Mutable
    public static int INVENTORY_SIZE;
    @Shadow
    @Final
    @Mutable
    public class_2371<class_1799> items;
    @Shadow
    @Final
    @Mutable
    public class_2371<class_1799> armor;
    @Shadow
    @Final
    @Mutable
    public class_2371<class_1799> offhand;
    @Shadow
    @Final
    public class_1657 player;
    @Mutable
    @Shadow
    @Final
    private List<class_2371<class_1799>> compartments;
    @Shadow
    public int selected;

    @Unique
    private int offSelected;
    @Unique
    private final class_1661 inv = (class_1661) (Object) this;
    @Unique
    private boolean slotChanged = false;

    @Inject(
            method = "<init>",
            at = @At("TAIL")
    )
    private void reSizer(class_1657 player, CallbackInfo ci) {
        SELECTION_SIZE = 9;
        INVENTORY_SIZE = 36;
        SLOT_OFFHAND = 40;
        this.items = class_2371.method_10213(INVENTORY_SIZE, class_1799.field_8037);
        this.compartments = ImmutableList.of(this.items, this.armor);
    }

    @ModifyConstant(
            method = "getSelectionSize",
            constant = @Constant(intValue = 9)
    )
    private static int tenSlots(int constant) {
        return SELECTION_SIZE;
    }

    @ModifyReturnValue(
            method = "isHotbarSlot",
            at = @At("RETURN")
    )
    private static boolean stillTenSlots(boolean original, @Local(argsOnly = true) int slot) {
        return slot >= -1 && slot < SELECTION_SIZE;
    }

    @ModifyConstant(
            method = "getSuitableHotbarSlot",
            constant = @Constant(
                    intValue = 9
            )
    )
    private int realSuitableSlot(int constant) {
        return SELECTION_SIZE;
    }

    @Inject(
            method = "setSelectedHotbarSlot",
            at = @At("HEAD"),
            cancellable = true
    )
    private void setSelectedSlot(int slot, CallbackInfo ci) {
        if (slot == this.offSelected) {
            this.selected = -1;
//            this.bobHands();
            ci.cancel();
        } else {
            if (this.offSelected == -1) {
                this.offSelected = this.selected;
//                this.bobHands();
            }
        }
    }

    @Inject(
            method = "getSelected",
            at = @At("HEAD"),
            cancellable = true
    )
    private void getSelectedItem(CallbackInfoReturnable<class_1799> cir) {
        if (selected == -1) {
            cir.setReturnValue(class_1799.field_8037);
            cir.cancel();
        }
    }

//    @Inject(
//            method = "getSelectedSlot",
//            at = @At("HEAD"),
//            cancellable = true
//    )
//    private void getSelectedSlot(CallbackInfoReturnable<Integer> cir) {
//        if (selected == -1) {
//            cir.setReturnValue(offSelected);
//            cir.cancel();
//        }
//    }
    
//    @Inject(
//            method = "addAndPickItem",
//            at = @At("HEAD"),
//            cancellable = true
//    )
//    private void addAndPickItem(CallbackInfo ci, @Local(argsOnly = true) ItemStack itemStack) {
//        if (isInverted(null)) {
//            this.addAndPickOffItem(itemStack);
//            ci.cancel();
//        }
//    }

//    @Inject(
//            method = "pickSlot",
//            at = @At("HEAD"),
//            cancellable = true
//    )
//    private void pickSlot(CallbackInfo ci, @Local(argsOnly = true) int index) {
//        if (isInverted(null)) {
//            this.pickOffSlot(index);
//            ci.cancel();
//        }
//    }

    @ModifyExpressionValue(
            method = "getSuitableHotbarSlot",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/world/entity/player/Inventory;selected:I"
            )
    )
    private int suitableSlotFixer(int original) {
        return this.getSelectedSlot();
    }

    @Redirect(
            method = "replaceWith",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/world/entity/player/Inventory;selected:I",
                    opcode = Opcodes.GETFIELD
            )
    )
    private int fixSlot(class_1661 instance) {
        return this.getSelectedSlot();
    }

    @Redirect(
            method = "replaceWith",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/world/entity/player/Inventory;selected:I",
                    opcode = Opcodes.PUTFIELD
            )
    )
    private void fixSlot(class_1661 inventory, int value) {
        inventory.method_61496(value);
    }

    @ModifyExpressionValue(
            method = "getSlotWithRemainingSpace",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/world/entity/player/Inventory;selected:I"
            )
    )
    private int fixSlotAgain(int original) {
        return this.getSelectedSlot();
    }

    @Inject(
            method = "removeFromSelected",
            at = @At("HEAD"),
            cancellable = true
    )
    private void removeFromOffhand(boolean removeStack, CallbackInfoReturnable<class_1799> cir) {
        if (isInverted(player)) {
            class_1799 itemStack = this.getOffSelectedItem();
            cir.setReturnValue(itemStack.method_7960() ? class_1799.field_8037 : this.method_5434(this.offSelected, removeStack ? itemStack.method_7947() : 1));
            cir.cancel();
        }
    }

    @ModifyReturnValue(
            method = "getContainerSize",
            at = @At("RETURN")
    )
    private int fixContainerSize(int original) {
        return this.items.size() + this.armor.size();
    }

    @Unique @Override
    public int getOffSelectedSlot() {
        if (offSelected == -1) return selected;
        return offSelected;
    }

    @Unique @Override
    public void setOffSelectedSlot(int slot) {
        if (slot == this.selected) {
            this.offSelected = -1;
//            this.bobHands();
        } else if (!class_1661.method_7380(slot)) {
            throw new IllegalArgumentException("Invalid selected slot");
        } else {
            if (this.selected == -1){
                this.selected = this.offSelected;
//                this.bobHands();
            }
            this.offSelected = slot;
        }
    }

    @Unique @Override
    public class_1799 getOffSelectedItem() {
        if (this.offSelected == -1) return class_1799.field_8037;
        return this.items.get(this.offSelected);
    }

    @Unique @Override
    public class_1799 setOffSelectedItem(class_1799 stack) {
        return this.items.set(this.getOffSelectedSlot(), stack);
    }

    @Unique @Override
    public void addAndPickOffItem(class_1799 stack) {
        this.setOffSelectedSlot(this.getOffSuitableHotbarSlot());
        this.itemPicker(stack, this.getOffSelectedSlot());
    }

    @Unique @Override
    public void addAndPickItem(class_1799 stack) {
        this.setOffSelectedSlot(inv.method_7386());
        this.itemPicker(stack, this.getSelectedSlot());
    }

    @Unique
    public void itemPicker(class_1799 stack, int slot) {
        if (!this.items.get(slot).method_7960()) {
            int i = inv.method_7376();
            if (i != -1) {
                this.items.set(i, this.items.get(slot));
            }
        }
        this.items.set(slot, stack);
    }

    @Unique @Override
    public void pickOffSlot(int index) {
        this.setOffSelectedSlot(this.getOffSuitableHotbarSlot());
        class_1799 itemStack = this.items.get(this.offSelected);
        this.items.set(this.offSelected, this.items.get(index));
        this.items.set(index, itemStack);
    }

    @Unique @Override
    public int getOffSuitableHotbarSlot() {
        int temp = this.getOffSelectedSlot();
        for (int i = 0; i < SELECTION_SIZE; i++) {
            int j = (temp + i) % SELECTION_SIZE;
            if (this.items.get(j).method_7960()) {
                return j;
            }
        }

        for (int ix = 0; ix < SELECTION_SIZE; ix++) {
            int j = (temp + ix) % SELECTION_SIZE;
            if (!this.items.get(j).method_7942()) {
                return j;
            }
        }

        return temp;
    }

    @Unique @Override
    public void doHandSwap() {
        if (this.selected == -1 || this.offSelected == -1) {
//            if (inv.getSelectedItem().isEmpty()) {
//                this.heldHand = EquipmentSlot.OFFHAND;
//                this.selected = this.offSelected;
//                this.offSelected = this.offSelected + 1 % SELECTION_SIZE;
//                inv.setSelectedItem(this.getOffSelectedItem());
//                this.setOffSelectedItem(ItemStack.EMPTY);
//            } else {
//                this.heldHand = EquipmentSlot.MAINHAND;
//                this.offSelected = this.selected;
//                this.selected = this.selected + 1 % SELECTION_SIZE;
//                this.setOffSelectedItem(inv.getSelectedItem());
//                inv.setSelectedItem(ItemStack.EMPTY);
//            }
//            player.inventoryMenu.broadcastChanges();
            int temp = this.offSelected;
            this.offSelected = this.selected;
            this.selected = temp;
            player.method_6021();
        }
    }

    @Unique @Override
    public boolean isSlotChanged() {
        if (!slotChanged) return false;
        slotChanged = false;
        return true;
    }

//    @Unique
//    private void bobHands() {
//        boolean bl = ((LivingEntityAccess) this.player).offhand(true);
//        this.player.resetAttackStrengthTicker();
//        ((LivingEntityAccess) this.player).offhand(false);
//        this.player.resetAttackStrengthTicker();
//        ((LivingEntityAccess) this.player).offhand(bl);
//        this.player.stopUsingItem();
//        slotChanged = true;
//    }

    @Unique @Override
    public void handleSideScroll(int x) {
        this.setOffSelectedSlot(class_9928.method_61972(x, this.getOffSelectedSlot(), class_1661.method_7368()));
    }

    @Unique @Override
    public int getSelectedSlot() {
        if  (selected < 0) return this.offSelected;
        return selected;
    }

//    @Unique @Override
//    public boolean shouldDisplayHand(InteractionHand hand) {
//        if (this.getOffSelectedItem().isEmpty() && inv.getSelectedItem().isEmpty()) return true;
//        if (switch (hand) {
//            case MAIN_HAND -> this.getOffSelectedItem().has(DataComponents.MAP_ID);
//            case OFF_HAND -> inv.getSelectedItem().has(DataComponents.MAP_ID);
//        }) return false;
//        return switch (hand) {
//            case OFF_HAND -> this.offSelected;
//            case MAIN_HAND -> this.selected;
//        } != -1;
//
//    }

//    @Unique @Override
//    public void tick() {
//        if (heldHand != null) {
//            switch (heldHand) {
//                case OFFHAND -> this.offSelected = -1;
//                case MAINHAND -> this.selected = -1;
//            }
//            heldHand = null;
//            player.inventoryMenu.broadcastChanges();
//        }
//    }
}
