package eva.ambidexterity.config;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import eva.ambidexterity.config.enums.BalanceMode;
import eva.ambidexterity.config.enums.DefaultBehavior;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import net.minecraft.class_2561;

import static eva.ambidexterity.config.AmbidexterityConfig.*;

public class AmbidexterityConfigScreen implements ModMenuApi {
    public static ConfigBuilder builder() {
        ConfigBuilder builder = ConfigBuilder.create()
                .setTitle(class_2561.method_43470("Simply Dual Wielding Config"))
                .setSavingRunnable(JsonConfigHelper::writeToConfig)
                .setEditable(true);
        AmbidexterityConfig INSTANCE = getInstance();
        AmbidexterityConfig SERVER_INSTANCE = getServerInstance();
        if (SERVER_INSTANCE != null) {
            builder.getOrCreateCategory(class_2561.method_43470("Server Settings"))
                    .addEntry(builder.entryBuilder()
                            .startEnumSelector(class_2561.method_43470("Server balance mode:"),
                                    BalanceMode.class, SERVER_INSTANCE.getMode())
                            .setTooltip(class_2561.method_43470("SERVER CONFIG; CHANGES MADE HERE ARE NOT RESPECTED"))
                            .build());
            if (SERVER_INSTANCE.getMode() == BalanceMode.CUSTOM_BALANCE)
                builder.getOrCreateCategory(class_2561.method_43470("Server Settings"))
                        .addEntry(builder.entryBuilder()
                                .startDoubleField(class_2561.method_43470("Dual wielding damage factor:"),
                                        SERVER_INSTANCE.getDualDamageFactor())
                                .setTooltip(class_2561.method_43470("SERVER CONFIG; CHANGES MADE HERE ARE NOT RESPECTED"))
                                .build())
                        .addEntry(builder.entryBuilder()
                                .startDoubleField(class_2561.method_43470("One handed damage factor:"),
                                        SERVER_INSTANCE.getOneHandedDamageFactor())
                                .setTooltip(class_2561.method_43470("SERVER CONFIG; CHANGES MADE HERE ARE NOT RESPECTED"))
                                .build())
                        .addEntry(builder.entryBuilder()
                                .startDoubleField(class_2561.method_43470("Two handed damage factor:"),
                                        SERVER_INSTANCE.getTwoHandedDamageFactor())
                                .setTooltip(class_2561.method_43470("SERVER CONFIG; CHANGES MADE HERE ARE NOT RESPECTED"))
                                .build())
                        .addEntry(builder.entryBuilder()
                                .startDoubleField(class_2561.method_43470("Dual wielding speed factor:"),
                                        SERVER_INSTANCE.getDualSpeedFactor())
                                .setTooltip(class_2561.method_43470("SERVER CONFIG; CHANGES MADE HERE ARE NOT RESPECTED"))
                                .build())
                        .addEntry(builder.entryBuilder()
                                .startDoubleField(class_2561.method_43470("One handed speed factor:"),
                                        SERVER_INSTANCE.getOneHandedSpeedFactor())
                                .setTooltip(class_2561.method_43470("SERVER CONFIG; CHANGES MADE HERE ARE NOT RESPECTED"))
                                .build())
                        .addEntry(builder.entryBuilder()
                                .startDoubleField(class_2561.method_43470("Two handed speed factor:"),
                                        SERVER_INSTANCE.getTwoHandedSpeedFactor())
                                .setTooltip(class_2561.method_43470("SERVER CONFIG; CHANGES MADE HERE ARE NOT RESPECTED"))
                                .build());
        }
        builder.getOrCreateCategory(class_2561.method_43470("Basic Settings"))
                .addEntry(builder.entryBuilder()
                        .startEnumSelector(class_2561.method_43470("Balance mode:"),
                                BalanceMode.class, INSTANCE.getMode())
                        .setDefaultValue(BalanceMode.PRETTY_MUCH_BALANCED)
                        .setSaveConsumer(AmbidexterityConfig::setMode)
                        .setTooltip(class_2561.method_43470("Determines damage & speed factors for\nitems with attribute modifiers for those attributes\n\nDual_wielding_is_broken: always 1.0x\nPetty_much_balanced:\n    dual gets 0.8x\n    one-handed gets 1.0x\n    two-handed gets 1.2x\n\nCheck the Factors tab for more info!"))
                        .build())
                .addEntry(builder.entryBuilder()
                        .startEnumSelector(class_2561.method_43470("Default action priority:"),
                                DefaultBehavior.class, INSTANCE.getDefaultBehavior())
                        .setDefaultValue(DefaultBehavior.USE)
                        .setTooltip(class_2561.method_43470("Priority when interacting with\ntools that also have a use action."))
                        .setSaveConsumer(AmbidexterityConfig::setDefaultBehavior)
                        .build())
                .addEntry(builder.entryBuilder()
                        .startBooleanToggle(class_2561.method_43470("Invert action priority by crouching:"), isInvertWithCrouch())
                        .setDefaultValue(true)
                        .setTooltip(class_2561.method_43470("You can also set a separate\nkey to handle this behavior!"))
                        .setSaveConsumer(AmbidexterityConfig::setInvertWithCrouch)
                        .build())
                .addEntry(builder.entryBuilder()
                        .startBooleanToggle(class_2561.method_43470("Toggle action inversion:"), isToggleInvert())
                        .setDefaultValue(false)
                        .setTooltip(class_2561.method_43470("With this setting on, the invert keybind\nis toggled for scrolling only. Crouching\n& using is always held."))
                        .setSaveConsumer(AmbidexterityConfig::setToggleInvert)
                        .build());
        builder.getOrCreateCategory(class_2561.method_43470("Factors"))
                .addEntry(builder.entryBuilder()
                        .startDoubleField(class_2561.method_43470("Dual wielding damage:"),
                                INSTANCE.getDualDamageFactor())
                        .setSaveConsumer(AmbidexterityConfig::setDualDamageFactor)
                        .setDefaultValue(0.8)
                        .setTooltip(class_2561.method_43470("Affects damage when both hands have\nan item with a combat attribute modifier\n(e.g. tools, weapons)"))
                        .build())
                .addEntry(builder.entryBuilder()
                        .startDoubleField(class_2561.method_43470("One handed damage:"),
                                INSTANCE.getOneHandedDamageFactor())
                        .setSaveConsumer(AmbidexterityConfig::setOneHandedDamageFactor)
                        .setDefaultValue(1.0)
                        .setTooltip(class_2561.method_43470("Affects damage when both hands are full\nbut only one has an item with\na combat attribute modifier"))
                        .build())
                .addEntry(builder.entryBuilder()
                        .startDoubleField(class_2561.method_43470("Two handed damage:"),
                                INSTANCE.getTwoHandedDamageFactor())
                        .setSaveConsumer(AmbidexterityConfig::setTwoHandedDamageFactor)
                        .setDefaultValue(1.2)
                        .setTooltip(class_2561.method_43470("Affects damage when both hands are on the same slot."))
                        .build())
                .addEntry(builder.entryBuilder()
                        .startDoubleField(class_2561.method_43470("Dual wielding attack speed:"),
                                INSTANCE.getDualSpeedFactor())
                        .setSaveConsumer(AmbidexterityConfig::setDualSpeedFactor)
                        .setDefaultValue(0.8)
                        .setTooltip(class_2561.method_43470("Affects attack speed when both hands have\nan item with a combat attribute modifier\n(e.g. tools, weapons)"))
                        .build())
                .addEntry(builder.entryBuilder()
                        .startDoubleField(class_2561.method_43470("One handed attack speed:"),
                                INSTANCE.getOneHandedSpeedFactor())
                        .setSaveConsumer(AmbidexterityConfig::setOneHandedSpeedFactor)
                        .setDefaultValue(1.0)
                        .setTooltip(class_2561.method_43470("Affects attack speed when both hands are full\nbut only one has an item with\na combat attribute modifier"))
                        .build())
                .addEntry(builder.entryBuilder()
                        .startDoubleField(class_2561.method_43470("Two handed attack speed:"),
                                INSTANCE.getTwoHandedSpeedFactor())
                        .setSaveConsumer(AmbidexterityConfig::setTwoHandedSpeedFactor)
                        .setDefaultValue(1.2)
                        .setTooltip(class_2561.method_43470("Affects attack speed when both hands are on the same slot."))
                        .build());
        builder.getOrCreateCategory(class_2561.method_43470("Invert List"))
                .addEntry(builder.entryBuilder()
                        .startStrList(class_2561.method_43470("Use Action Disabled Items"),
                                AmbidexterityConfig.getInvertList())
                        .setInsertButtonEnabled(true)
                        .setDeleteButtonEnabled(true)
                        .setTooltip(class_2561.method_43470("Enter an item TYPE."))
                        .setCellErrorSupplier(getErrorSupplier())
                        .setDefaultValue(def())
                        .setSaveConsumer(AmbidexterityConfig::setInvertList)
                        .build());
        return builder;
    }

    @Override
    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return parent -> {
            // Return the screen here with the one you created from Cloth Config Builder
            return builder().setParentScreen(parent).build();
        };
    }
}