package eva.ambidexterity.config;

import eva.ambidexterity.access.InventoryAccess;
import eva.ambidexterity.access.LivingEntityAccess;
import eva.ambidexterity.config.enums.DefaultBehavior;
import eva.ambidexterity.config.enums.Handy;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_5134;
import net.minecraft.class_7923;

import static eva.ambidexterity.AmbidexterityClient.isInvertedNoToggle;
import static eva.ambidexterity.config.AmbidexterityConfig.getInstance;
import static eva.ambidexterity.config.AmbidexterityConfig.getServerInstance;

public class ConfigInterpreter {

    private static final AmbidexterityConfig[] INSTANCE = {getServerInstance(), getInstance()};
    private static Boolean server;
    private static boolean[] handy = {false, false};

    private static boolean checkServer() {
        if (server == null) {
            server = INSTANCE[0] != null;
        }
        return server;
    }

    public static boolean checkInversion(class_1799 stack) {
        boolean bl = (INSTANCE[1].getDefaultBehavior() == DefaultBehavior.ATTACK);
        if (AmbidexterityConfig.getInvertItems().contains(class_7923.field_41178.method_10221(stack.method_7909()))) bl = !bl;
        if (isInvertedNoToggle()) bl = !bl;
        return bl;
    }

    public static float modifyDamage(float damage, class_1657 player) {
        boolean bl = ((LivingEntityAccess) player).offhand(false);
        class_1268 hand = bl ? class_1268.field_5810 : class_1268.field_5808;
        if (player.method_5998(hand).method_7960()) {
            ((LivingEntityAccess) player).offhand(bl);
            return damage;
        }
        int i = 1;
        if (checkServer()) i = 0;
        Handy handed;
        if (handy[0] || handy[1]) {
            if (handy[0] && handy[1]) handed = Handy.DUAL;
            else if (player.method_31548().method_67532() == ((InventoryAccess) player.method_31548()).getOffSelectedSlot())
                handed = Handy.TWO_HAND;
            else handed = Handy.ONE_HAND;
        }
        else {
            ((LivingEntityAccess) player).offhand(bl);
            return damage;
        }
        double[] vals = switch (INSTANCE[i].getMode()) {
            case PRETTY_MUCH_BALANCED -> new double[]{.8, 1, 1.2};
            case CUSTOM_BALANCE -> INSTANCE[i].getValues();
            default -> new double[]{1, 1, 1};
        };
        damage *= (float) vals[handed.ordinal()];
        ((LivingEntityAccess) player).offhand(bl);
        return damage;
    }

    public static float modifyASpd(float refreshRate, class_1657 player, class_1268 hand) {
        if (player.method_5998(hand).method_7960()) return refreshRate;
        int i = 1;
        if (checkServer()) i = 0;
        Handy handed;
        if (handy[0] || handy[1]) {
            if (handy[0] && handy[1]) handed = Handy.DUAL;
            else if (player.method_31548().method_67532() == ((InventoryAccess) player.method_31548()).getOffSelectedSlot())
                handed = Handy.TWO_HAND;
            else handed = Handy.ONE_HAND;
        }
        else return refreshRate;
        double[] vals = switch (INSTANCE[i].getMode()) {
            case PRETTY_MUCH_BALANCED -> new double[]{.8, 1, 1.2};
            case CUSTOM_BALANCE -> INSTANCE[i].getValues();
            default -> new double[]{1, 1, 1};
        };
        refreshRate /= (float) vals[(handed.ordinal() + 3) % vals.length];
        return refreshRate;
    }

    public static void handFixer(class_1657 player) {
        handy = new boolean[]{false, false};
        for (final int[] j = {0}; j[0] < 2; ++j[0]) {
            try {
                player.method_5998(class_1268.values()[j[0]]).method_57354(class_1304.field_6173, (attribute, modifier) -> {
                    if (attribute == class_5134.field_23721) handy[j[0]] = true;
                });
            } catch (NullPointerException exception) {
                handy[j[0]] = false;
            }
        }
    }

}


