package eva.ambidexterity.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import eva.ambidexterity.access.InventoryAccess;
import eva.ambidexterity.access.LivingEntityAccess;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.At.Shift;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.Function;

import static eva.ambidexterity.AmbidexterityClient.sprindicator;

@Environment(EnvType.CLIENT)
@Mixin(class_329.class)
public abstract class GuiMixin {

    @Shadow @Final private class_310 minecraft;
    @Shadow @Final private static class_2960 HOTBAR_SELECTION_SPRITE;
    @Shadow private class_1657 shadow$getCameraPlayer() {return null;}

    @Unique private static final int center = 91;

    @Unique private static final class_2960 CHI_FULL_TEXTURE = class_2960.method_43902("ambidexterity", "hud/crosshair_attack_indicator_full");
    @Unique private static final class_2960 CHI_BACKGROUND_TEXTURE = class_2960.method_43902("ambidexterity", "hud/crosshair_attack_indicator_background");
    @Unique private static final class_2960 CHI_PROGRESS_TEXTURE = class_2960.method_43902("ambidexterity", "hud/crosshair_attack_indicator_progress");

    @Unique private static final class_2960 HAI_BACKGROUND_TEXTURE = class_2960.method_43902("ambidexterity", "hud/hotbar_attack_indicator_background");
    @Unique private static final class_2960 HAI_PROGRESS_TEXTURE = class_2960.method_43902("ambidexterity", "hud/hotbar_attack_indicator_progress");

    @Inject(method = "renderCrosshair", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/player/LocalPlayer;getAttackStrengthScale(F)F", shift = Shift.AFTER))
    private void renderCrosshairMixin(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        assert this.minecraft.field_1724 != null;
        boolean varHolder = ((LivingEntityAccess) this.minecraft.field_1724).offhand(true);
        float f = this.minecraft.field_1724.method_7261(0.0F);
        boolean bl = false;
        if (this.minecraft.field_1692 != null && this.minecraft.field_1692 instanceof class_1309 && f >= 1.0F) {
            bl = this.minecraft.field_1724.method_7279() > 5.0F;
            bl &= this.minecraft.field_1692.method_5805();
        }

        int j = context.method_51443() / 2 - 10;
        int k = context.method_51421() / 2 - 8;
        if (bl) {
            context.method_52706(class_1921::method_62280, CHI_FULL_TEXTURE, k, j - 16, 16, 16);
        } else if (f < 1.0F) {
            int l = (int) (f * 17.0F);
            context.method_52706(class_1921::method_62280, CHI_BACKGROUND_TEXTURE, k, j - 4, 16, 4);
            context.method_52708(class_1921::method_62280, CHI_PROGRESS_TEXTURE, 16, 4, 17 - l, 0, k + 17 - l, j - 4, l, 4);
        }
        ((LivingEntityAccess) this.minecraft.field_1724).offhand(varHolder);
    }

    @Inject(method = "renderItemHotbar", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/player/LocalPlayer;getAttackStrengthScale(F)F", shift = Shift.AFTER))
    private void renderHotbar(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        assert this.minecraft.field_1724 != null;
        boolean varHolder = ((LivingEntityAccess) this.minecraft.field_1724).offhand(true);
        float f = this.minecraft.field_1724.method_7261(0.0F);
        int i = context.method_51421() / 2;
        if (f < 1.0F) {
            int n = context.method_51443() - 20;
            int a = 0;
            if (sprindicator()) a = 24;
            int o = i + 91 + 6 + a;
            if (this.minecraft.field_1724.method_6068().method_5928() == class_1306.field_6183) {
                o = i - 91 - 22 - a;
            }

            int p = (int) (f * 19.0F);
            context.method_52706(class_1921::method_62277, HAI_BACKGROUND_TEXTURE, o, n, 18, 18);
            context.method_52708(class_1921::method_62277, HAI_PROGRESS_TEXTURE, 18, 18, 0, 18 - p, o, n + 18 - p, 18, p);
        }
        ((LivingEntityAccess) this.minecraft.field_1724).offhand(varHolder);
    }

//    @Redirect(
//            method = "renderItemHotbar",
//            at = @At(
//                    value = "INVOKE",
//                    target = "Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/resources/ResourceLocation;IIII)V",
//                    ordinal = 0
//            )
//    )
//    private void hotbarExtender(GuiGraphics guiGraphics, RenderPipeline pipeline, ResourceLocation sprite, int x, int y, int width, int height) {
//        int i = guiGraphics.guiWidth() / 2;
//        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, sprite, 182, 22, 0, 0, i - center, guiGraphics.guiHeight() - 22, center, 22);
//        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, sprite, 182, 22, 81, 0, i, guiGraphics.guiHeight() - 22, center, 22);
//    }

    @Redirect(
            method = "renderItemHotbar",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Ljava/util/function/Function;Lnet/minecraft/resources/ResourceLocation;IIII)V",
                    ordinal = 1
            )
    )
    private void renderSelectors(class_332 guiGraphics, Function<class_2960, class_1921> renderTypeGetter, class_2960 sprite, int x, int y, int width, int height) {
        int i = guiGraphics.method_51421() / 2;
        class_1657 player = this.shadow$getCameraPlayer();
        assert player != null;
        //main selector
        int um = player.method_6068() == class_1306.field_6183 ? 12 : 0;
        guiGraphics.method_52708(
                class_1921::method_62277, HOTBAR_SELECTION_SPRITE, 24, 23, um, 0, i - center - 1 + player.method_31548().method_67532() * 20 + um, guiGraphics.method_51443() - 22 - 1, 12, 23
        );
        //offhand selector
        guiGraphics.method_52708(
                class_1921::method_62277, HOTBAR_SELECTION_SPRITE, 24, 23, 12 - um, 0, i - center - 1 + ((InventoryAccess) player.method_31548()).getOffSelectedSlot() * 20 + 12 - um, guiGraphics.method_51443() - 22 - 1, 12, 23
        );
    }

    @ModifyExpressionValue(
            method = "renderItemHotbar",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Player;getOffhandItem()Lnet/minecraft/world/item/ItemStack;"
            )
    )
    private class_1799 noOffhandSlot(class_1799 itemStack) {
        return class_1799.field_8037;
    }

    @ModifyConstant(
            method = "renderItemHotbar",
            constant = @Constant(
                    intValue = 9,
                    ordinal = 0
            )
    )
    private int itIsTenGodDammit(int constant) {
        return class_1661.method_7368();
    }

    @ModifyConstant(
            method = "renderItemHotbar",
            constant = @Constant(
                    intValue = 91
            )
    )
    private int shiftHotbar(int constant) {
        return center;
    }

    @ModifyConstant(
            method = "renderItemHotbar",
            constant = @Constant(
                    intValue = 90,
                    ordinal = 0
            )
    )
    private int shiftItems(int constant) {
        return center - 1;
    }
}
