/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.config;

import fin.starhud.config.ConditionalSettings;
import fin.starhud.helper.GrowthDirectionX;
import fin.starhud.helper.GrowthDirectionY;
import fin.starhud.helper.ScreenAlignmentX;
import fin.starhud.helper.ScreenAlignmentY;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.minecraft.client.Minecraft;

public class BaseHUDSettings
implements ConfigData {
    @Comment(value="Toggle HUD")
    public boolean shouldRender;
    public int x;
    public int y;
    @Comment(value="HUD default Horizontal location")
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public ScreenAlignmentX originX;
    @Comment(value="HUD default Vertical location")
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public ScreenAlignmentY originY;
    @Comment(value="Which way should the HUD goes when a the texture increases? (Recommended to go the opposite way from Alignment)")
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public GrowthDirectionX growthDirectionX;
    @Comment(value="Which way should the HUD goes when a the texture increases? (Recommended to go the opposite way from Alignment)")
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public GrowthDirectionY growthDirectionY;
    @ConfigEntry.BoundedDiscrete(max=6L)
    @Comment(value="Set to 0 for default GUI Scale")
    public int scale = 0;
    public List<ConditionalSettings> conditions = new ArrayList<ConditionalSettings>();

    public BaseHUDSettings(boolean shouldRender, int x, int y, ScreenAlignmentX originX, ScreenAlignmentY originY, GrowthDirectionX growthDirectionX, GrowthDirectionY growthDirectionY) {
        this.shouldRender = shouldRender;
        this.x = x;
        this.y = y;
        this.originX = originX;
        this.originY = originY;
        this.growthDirectionX = growthDirectionX;
        this.growthDirectionY = growthDirectionY;
    }

    public boolean shouldRender() {
        if (!this.shouldRender) {
            return false;
        }
        for (ConditionalSettings condition : this.conditions) {
            if (condition.shouldRender()) continue;
            return false;
        }
        return true;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public GrowthDirectionX getGrowthDirectionX() {
        if (this.growthDirectionX == null) {
            this.growthDirectionX = this.getX() > 0 ? GrowthDirectionX.RIGHT : (this.getX() < 0 ? GrowthDirectionX.LEFT : GrowthDirectionX.CENTER);
        }
        return this.growthDirectionX;
    }

    public GrowthDirectionY getGrowthDirectionY() {
        if (this.growthDirectionY == null) {
            this.growthDirectionY = this.getY() > 0 ? GrowthDirectionY.DOWN : (this.getY() < 0 ? GrowthDirectionY.UP : GrowthDirectionY.MIDDLE);
        }
        return this.growthDirectionY;
    }

    public ScreenAlignmentX getOriginX() {
        if (this.originX == null) {
            this.originX = this.getX() > 0 ? ScreenAlignmentX.LEFT : (this.getX() < 0 ? ScreenAlignmentX.RIGHT : ScreenAlignmentX.CENTER);
        }
        return this.originX;
    }

    public ScreenAlignmentY getOriginY() {
        if (this.originY == null) {
            this.originY = this.getY() > 0 ? ScreenAlignmentY.TOP : (this.getY() < 0 ? ScreenAlignmentY.BOTTOM : ScreenAlignmentY.MIDDLE);
        }
        return this.originY;
    }

    public int getScale() {
        return this.scale;
    }

    public List<ConditionalSettings> getConditions() {
        return this.conditions;
    }

    public float getScaledFactor() {
        return this.getScale() == 0 ? 1.0f : (float)Minecraft.m_91087_().m_91268_().m_85449_() / (float)this.getScale();
    }

    public int getCalculatedPosX() {
        return this.getX() + (int)((float)this.getOriginX().getAlignmentPos(Minecraft.m_91087_().m_91268_().m_85445_()) * this.getScaledFactor());
    }

    public int getCalculatedPosY() {
        return this.getY() + (int)((float)this.getOriginY().getAlignmentPos(Minecraft.m_91087_().m_91268_().m_85446_()) * this.getScaledFactor());
    }
}

