/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import fin.starhud.Helper;
import fin.starhud.helper.Box;
import fin.starhud.helper.GrowthDirectionX;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class RenderUtils {
    private static final ResourceLocation DURABILITY_TEXTURE = ResourceLocation.m_214293_((String)"starhud", (String)"hud/durability_bar.png");
    private static final ResourceLocation DURABILITY_BACKGROUND_TEXTURE = ResourceLocation.m_214293_((String)"starhud", (String)"hud/durability_background.png");
    private static final ResourceLocation ITEM_DURABILITY_TEXTURE = ResourceLocation.m_214293_((String)"starhud", (String)"hud/big_durability_bar.png");
    private static final ResourceLocation ITEM_DURABILITY_BACKGROUND_TEXTURE = ResourceLocation.m_214293_((String)"starhud", (String)"hud/big_durability_background.png");
    private static final int DURABILITY_WIDTH = 39;
    private static final int ITEM_DURABILITY_WIDTH = 68;
    private static final Minecraft CLIENT = Minecraft.m_91087_();
    private static final Box tempBox = new Box(0, 0);

    public static void fillRoundedRightSide(GuiGraphics context, int x1, int y1, int x2, int y2, int color) {
        context.m_280509_(x1, y1, x2 - 1, y2, color);
        context.m_280509_(x2 - 1, y1 + 1, x2, y2 - 1, color);
    }

    public static int getItemBarStep(ItemStack stack, int maxStep) {
        return Mth.m_14045_((int)Math.round((float)maxStep - (float)stack.m_41773_() * (float)maxStep / (float)stack.m_41776_()), (int)0, (int)maxStep);
    }

    public static int getItemBarColor(int stackStep, int maxStep) {
        return Mth.m_14169_((float)(0.35f * (float)stackStep / (float)maxStep), (float)0.45f, (float)0.95f);
    }

    public static Box renderDurabilityHUD(GuiGraphics context, ResourceLocation ICON, ItemStack stack, int x, int y, float v, int textureWidth, int textureHeight, int color, boolean drawBar, boolean renderItem, GrowthDirectionX textureGrowth) {
        if (renderItem) {
            return RenderUtils.renderItemDurability(context, stack, x, y, drawBar, textureGrowth);
        }
        return RenderUtils.renderDurability(context, ICON, stack, x, y, v, textureWidth, textureHeight, color, drawBar, textureGrowth);
    }

    public static Box renderItemDurability(GuiGraphics context, ItemStack stack, int x, int y, boolean drawBar, GrowthDirectionX textureGrowth) {
        if (drawBar) {
            return RenderUtils.renderItemDurabilityBar(context, stack, x, y, textureGrowth);
        }
        return RenderUtils.renderItemDurabilityNumber(context, stack, x, y, textureGrowth);
    }

    public static Box renderDurability(GuiGraphics context, ResourceLocation ICON, ItemStack stack, int x, int y, float v, int textureWidth, int textureHeight, int color, boolean drawBar, GrowthDirectionX textureGrowth) {
        if (drawBar) {
            return RenderUtils.renderDurabilityBar(context, ICON, stack, x, y, v, textureWidth, textureHeight, color, textureGrowth);
        }
        return RenderUtils.renderDurabilityNumber(context, ICON, stack, x, y, v, textureWidth, textureHeight, color, textureGrowth);
    }

    public static Box renderItemDurabilityBar(GuiGraphics context, ItemStack stack, int x, int y, GrowthDirectionX textureGrowth) {
        int step = RenderUtils.getItemBarStep(stack, 10);
        int durabilityColor = RenderUtils.getItemBarColor(step, 10) | 0xFF000000;
        RenderUtils.drawTextureHUD(context, ITEM_DURABILITY_BACKGROUND_TEXTURE, x -= textureGrowth.getGrowthDirection(68), y, 0.0f, 0.0f, 101, 22, 101, 22);
        context.m_280480_(stack, x + 3, y + 3);
        if (step != 0) {
            RenderUtils.drawTextureHUD(context, ITEM_DURABILITY_TEXTURE, x + 28, y + 4, 0.0f, 0.0f, 7 * step, 14, 70, 14, durabilityColor);
        }
        tempBox.setBoundingBox(x, y, 101, 22, durabilityColor);
        return tempBox;
    }

    public static Box renderItemDurabilityNumber(GuiGraphics context, ItemStack stack, int x, int y, GrowthDirectionX textureGrowth) {
        int damage = stack.m_41773_();
        int maxDamage = stack.m_41776_();
        int remaining = maxDamage - damage;
        String durability = remaining + "/" + maxDamage;
        int durabilityWidth = RenderUtils.CLIENT.f_91062_.m_92895_(durability) - 1;
        int textColor = RenderUtils.getItemBarColor(remaining, maxDamage) | 0xFF000000;
        RenderUtils.drawTextureHUD(context, ITEM_DURABILITY_BACKGROUND_TEXTURE, x -= textureGrowth.getGrowthDirection(durabilityWidth), y, 0.0f, 0.0f, 22, 22, 101, 22);
        context.m_280480_(stack, x + 3, y + 3);
        RenderUtils.fillRoundedRightSide(context, x + 23, y, x + 22 + 1 + 5 + durabilityWidth + 5, y + 22, Integer.MIN_VALUE);
        RenderUtils.drawTextHUD(context, durability, x + 22 + 1 + 5, y + 7, textColor, false);
        tempBox.setBoundingBox(x, y, 28 + durabilityWidth + 5, 22, textColor);
        return tempBox;
    }

    public static Box renderDurabilityBar(GuiGraphics context, ResourceLocation ICON, ItemStack stack, int x, int y, float v, int textureWidth, int textureHeight, int color, GrowthDirectionX textureGrowth) {
        int step = RenderUtils.getItemBarStep(stack, 10);
        int durabilityColor = RenderUtils.getItemBarColor(step, 10) | 0xFF000000;
        RenderUtils.drawTextureHUD(context, ICON, x -= textureGrowth.getGrowthDirection(39), y, 0.0f, v, 13, 13, textureWidth, textureHeight, color);
        RenderUtils.drawTextureHUD(context, DURABILITY_BACKGROUND_TEXTURE, x + 14, y, 0.0f, 0.0f, 49, 13, 49, 13);
        if (step != 0) {
            RenderUtils.drawTextureHUD(context, DURABILITY_TEXTURE, x + 19, y + 3, 0.0f, 0.0f, 4 * step, 7, 40, 7, durabilityColor);
        }
        tempBox.setBoundingBox(x, y, 63, 13, color);
        return tempBox;
    }

    public static Box renderDurabilityNumber(GuiGraphics context, ResourceLocation ICON, ItemStack stack, int x, int y, float v, int textureWidth, int textureHeight, int color, GrowthDirectionX textureGrowth) {
        int damage = stack.m_41773_();
        int maxDamage = stack.m_41776_();
        int remaining = maxDamage - damage;
        String remainingStr = Helper.toSuperscript(Integer.toString(remaining)) + "/";
        String maxDamageStr = Helper.toSubscript(Integer.toString(maxDamage));
        int remainingTextWidth = RenderUtils.CLIENT.f_91062_.m_92895_(remainingStr);
        int maxDamageTextWidth = RenderUtils.CLIENT.f_91062_.m_92895_(maxDamageStr);
        int textColor = RenderUtils.getItemBarColor(remaining, maxDamage) | 0xFF000000;
        RenderUtils.drawTextureHUD(context, ICON, x -= textureGrowth.getGrowthDirection(remainingTextWidth + maxDamageTextWidth), y, 0.0f, v, 13, 13, textureWidth, textureHeight, color);
        RenderUtils.fillRoundedRightSide(context, x + 14, y, x + 14 + remainingTextWidth + maxDamageTextWidth + 10, y + 13, Integer.MIN_VALUE);
        RenderUtils.drawTextHUD(context, remainingStr, x + 14 + 5, y + 3, textColor, false);
        RenderUtils.drawTextHUD(context, maxDamageStr, x + 14 + 5 + remainingTextWidth, y + 3 - 1, textColor, false);
        tempBox.setBoundingBox(x, y, 14 + remainingTextWidth + maxDamageTextWidth + 10, 13, color);
        return tempBox;
    }

    public static void drawTextureAlphaColor(GuiGraphics context, ResourceLocation identifier, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight, int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
        context.m_280163_(identifier, x, y, u, v, width, height, textureWidth, textureHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    public static void drawTextureAlpha(GuiGraphics context, ResourceLocation identifier, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        RenderSystem.enableBlend();
        context.m_280163_(identifier, x, y, u, v, width, height, textureWidth, textureHeight);
        RenderSystem.disableBlend();
    }

    public static void drawTextureColor(GuiGraphics context, ResourceLocation identifier, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight, int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
        context.m_280163_(identifier, x, y, u, v, width, height, textureWidth, textureHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawTextureHUD(GuiGraphics context, ResourceLocation identifier, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight, int color) {
        RenderUtils.drawTextureAlphaColor(context, identifier, x, y, u, v, width, height, textureWidth, textureHeight, color);
    }

    public static void drawTextureHUD(GuiGraphics context, ResourceLocation identifier, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        RenderUtils.drawTextureAlpha(context, identifier, x, y, u, v, width, height, textureWidth, textureHeight);
    }

    public static void drawTextHUD(GuiGraphics context, String str, int x, int y, int color, boolean shadow) {
        FormattedCharSequence orderedText = FormattedCharSequence.m_13714_((String)str, (Style)Style.f_131099_);
        context.m_280649_(RenderUtils.CLIENT.f_91062_, orderedText, x, y, color, shadow);
    }

    public static void drawTextHUD(GuiGraphics context, FormattedCharSequence text, int x, int y, int color, boolean shadow) {
        context.m_280649_(RenderUtils.CLIENT.f_91062_, text, x, y, color, shadow);
    }
}

