/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.helper;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;

public record StatusEffectAttribute(int maxDuration, int amplifier, boolean isAmbient) {
    private static final Map<MobEffect, StatusEffectAttribute> STATUS_EFFECT_ATTRIBUTE_MAP = new HashMap<MobEffect, StatusEffectAttribute>();

    public static StatusEffectAttribute getStatusEffectAttribute(MobEffectInstance effect) {
        return STATUS_EFFECT_ATTRIBUTE_MAP.computeIfAbsent(effect.m_19544_(), key -> new StatusEffectAttribute(effect.m_19557_(), effect.m_19564_(), effect.m_19571_()));
    }

    public static void updateStatusEffectAttribute(MobEffect effectRegistry, int maxDuration, int amplifier, boolean isAmbient) {
        StatusEffectAttribute newEffect = new StatusEffectAttribute(maxDuration, amplifier, isAmbient);
        STATUS_EFFECT_ATTRIBUTE_MAP.put(effectRegistry, newEffect);
    }

    public static void removeStatusEffectAttribute(MobEffect effectRegistry) {
        STATUS_EFFECT_ATTRIBUTE_MAP.remove(effectRegistry);
    }

    public static boolean shouldUpdate(MobEffectInstance current, StatusEffectAttribute cached) {
        return current.m_19564_() != cached.amplifier() || current.m_19571_() != cached.isAmbient() || current.m_19557_() > cached.maxDuration();
    }

    public static Map<MobEffect, StatusEffectAttribute> getStatusEffectAttributeMap() {
        return STATUS_EFFECT_ATTRIBUTE_MAP;
    }
}

