/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.hud;

import fin.starhud.hud.AbstractHUD;
import fin.starhud.hud.HUDInterface;
import fin.starhud.hud.implementation.ArmorHUD;
import fin.starhud.hud.implementation.BiomeHUD;
import fin.starhud.hud.implementation.ClockInGameHUD;
import fin.starhud.hud.implementation.ClockSystemHUD;
import fin.starhud.hud.implementation.CoordinateHUD;
import fin.starhud.hud.implementation.DayHUD;
import fin.starhud.hud.implementation.DirectionHUD;
import fin.starhud.hud.implementation.EffectHUD;
import fin.starhud.hud.implementation.FPSHUD;
import fin.starhud.hud.implementation.InventoryHUD;
import fin.starhud.hud.implementation.LeftHandHUD;
import fin.starhud.hud.implementation.PingHUD;
import fin.starhud.hud.implementation.RightHandHUD;
import fin.starhud.hud.implementation.TargetedCrosshairHUD;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;

public class HUDComponent {
    static HUDComponent instance;
    public final ArrayList<AbstractHUD> huds = new ArrayList();
    public final AbstractHUD effectHUD;
    public boolean shouldRenderInGameScreen;

    private HUDComponent() {
        this.huds.add(new ArmorHUD());
        this.huds.add(new BiomeHUD());
        this.huds.add(new ClockInGameHUD());
        this.huds.add(new ClockSystemHUD());
        this.huds.add(new DayHUD());
        this.huds.add(new CoordinateHUD());
        this.huds.add(new DirectionHUD());
        this.huds.add(new FPSHUD());
        this.huds.add(new InventoryHUD());
        this.huds.add(new PingHUD());
        this.huds.add(new LeftHandHUD());
        this.huds.add(new RightHandHUD());
        this.huds.add(new TargetedCrosshairHUD());
        this.effectHUD = new EffectHUD();
        this.shouldRenderInGameScreen = true;
    }

    public static HUDComponent getInstance() {
        if (instance == null) {
            instance = new HUDComponent();
        }
        return instance;
    }

    public void renderAll(GuiGraphics context) {
        for (HUDInterface hUDInterface : this.huds) {
            if (!hUDInterface.shouldRender()) continue;
            hUDInterface.render(context);
        }
    }

    public void updateAll() {
        for (HUDInterface hUDInterface : this.huds) {
            hUDInterface.update();
        }
        this.effectHUD.update();
    }

    public void setShouldRenderInGameScreen(boolean shouldRenderInGameScreen) {
        this.shouldRenderInGameScreen = shouldRenderInGameScreen;
    }

    public boolean shouldRenderInGameScreen() {
        return this.shouldRenderInGameScreen;
    }
}

