/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.hud.implementation;

import fin.starhud.Main;
import fin.starhud.config.hud.ArmorSettings;
import fin.starhud.helper.Box;
import fin.starhud.helper.RenderUtils;
import fin.starhud.hud.AbstractHUD;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ArmorHUD
extends AbstractHUD {
    private static final ArmorSettings ARMOR_SETTINGS = Main.settings.armorSettings;
    private static final ResourceLocation ARMOR_BACKGROUND_TEXTURE = ResourceLocation.m_214293_((String)"starhud", (String)"hud/armor.png");
    private static final ArmorSettings.ArmorPieceSetting[] PIECE_SETTINGS = new ArmorSettings.ArmorPieceSetting[]{ArmorHUD.ARMOR_SETTINGS.helmet, ArmorHUD.ARMOR_SETTINGS.chestplate, ArmorHUD.ARMOR_SETTINGS.leggings, ArmorHUD.ARMOR_SETTINGS.boots};
    private static final int TEXTURE_WIDTH = 24;
    private static final int TEXTURE_HEIGHT = 13;
    private static final int ITEM_TEXTURE_WIDTH = 33;
    private static final int ITEM_TEXTURE_HEIGHT = 22;
    private static boolean needBoxUpdate = true;
    private static final Minecraft CLIENT = Minecraft.m_91087_();

    public ArmorHUD() {
        super(ArmorHUD.ARMOR_SETTINGS.base);
    }

    @Override
    public String getName() {
        return "Armor HUD";
    }

    @Override
    public int getBaseHUDWidth() {
        return ArmorHUD.PIECE_SETTINGS[0].renderItem || ArmorHUD.PIECE_SETTINGS[1].renderItem || ArmorHUD.PIECE_SETTINGS[2].renderItem || ArmorHUD.PIECE_SETTINGS[3].renderItem ? 33 : 24;
    }

    @Override
    public int getBaseHUDHeight() {
        return ArmorHUD.PIECE_SETTINGS[0].renderItem || ArmorHUD.PIECE_SETTINGS[1].renderItem || ArmorHUD.PIECE_SETTINGS[2].renderItem || ArmorHUD.PIECE_SETTINGS[3].renderItem ? 22 : 13;
    }

    @Override
    public boolean shouldRender() {
        return super.shouldRender() && (ArmorHUD.PIECE_SETTINGS[0].shouldRender || ArmorHUD.PIECE_SETTINGS[1].shouldRender || ArmorHUD.PIECE_SETTINGS[2].shouldRender || ArmorHUD.PIECE_SETTINGS[3].shouldRender);
    }

    @Override
    public boolean renderHUD(GuiGraphics context) {
        int armorIndex = 3;
        boolean rendered = false;
        for (ItemStack armor : ArmorHUD.CLIENT.f_91074_.m_6168_()) {
            if (ArmorHUD.PIECE_SETTINGS[armorIndex].shouldRender && !armor.m_41619_() && armor.m_41763_()) {
                Box tempBox = RenderUtils.renderDurabilityHUD(context, ARMOR_BACKGROUND_TEXTURE, armor, this.x + ArmorHUD.PIECE_SETTINGS[armorIndex].xOffset, this.y + ArmorHUD.PIECE_SETTINGS[armorIndex].yOffset, 14 * armorIndex, 13, 55, ArmorHUD.PIECE_SETTINGS[armorIndex].color | 0xFF000000, ArmorHUD.PIECE_SETTINGS[armorIndex].drawBar, ArmorHUD.PIECE_SETTINGS[armorIndex].renderItem, ArmorHUD.ARMOR_SETTINGS.base.growthDirectionX);
                rendered = true;
                if (needBoxUpdate) {
                    if (this.boundingBox.isEmpty()) {
                        this.boundingBox.setBoundingBox(tempBox.getX(), tempBox.getY(), tempBox.width(), tempBox.getHeight(), tempBox.getColor());
                    } else {
                        this.boundingBox.mergeWith(tempBox);
                    }
                }
            }
            --armorIndex;
        }
        needBoxUpdate = false;
        return rendered;
    }

    @Override
    public void update() {
        super.update();
        needBoxUpdate = true;
        this.boundingBox.setEmpty(true);
    }
}

