/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.hud.implementation;

import fin.starhud.Helper;
import fin.starhud.Main;
import fin.starhud.config.hud.BiomeSettings;
import fin.starhud.helper.RenderUtils;
import fin.starhud.hud.AbstractHUD;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class BiomeHUD
extends AbstractHUD {
    private static final BiomeSettings BIOME_SETTINGS = Main.settings.biomeSettings;
    private static final ResourceLocation DIMENSION_TEXTURE = ResourceLocation.m_214293_((String)"starhud", (String)"hud/biome.png");
    private static Component cachedBiomeNameText;
    private static Holder<Biome> cachedBiome;
    private static int cachedTextWidth;
    private static final int TEXTURE_WIDTH = 24;
    private static final int TEXTURE_HEIGHT = 13;
    private static final Minecraft CLIENT;

    public BiomeHUD() {
        super(BiomeHUD.BIOME_SETTINGS.base);
    }

    @Override
    public String getName() {
        return "Biome HUD";
    }

    @Override
    public boolean renderHUD(GuiGraphics context) {
        Font font = BiomeHUD.CLIENT.f_91062_;
        BlockPos blockPos = BiomeHUD.CLIENT.f_91074_.m_20183_();
        Holder currentBiome = BiomeHUD.CLIENT.f_91073_.m_204166_(blockPos);
        if (cachedBiome != currentBiome) {
            Optional biomeKey = currentBiome.m_203543_();
            if (biomeKey.isPresent()) {
                ResourceLocation biomeId = ((ResourceKey)biomeKey.get()).m_135782_();
                String translatableKey = "biome." + biomeId.m_135827_() + "." + biomeId.m_135815_();
                cachedBiomeNameText = Language.m_128107_().m_6722_(translatableKey) ? Component.m_237115_((String)translatableKey) : Component.m_237113_((String)Helper.idNameFormatter(BiomeHUD.getBiomeIdAsString((Holder<Biome>)currentBiome)));
            } else {
                cachedBiomeNameText = Component.m_237113_((String)"Unregistered");
            }
            cachedBiome = currentBiome;
            cachedTextWidth = font.m_92852_((FormattedText)cachedBiomeNameText);
        }
        int dimensionIndex = BiomeHUD.getDimensionIndex((ResourceKey<Level>)BiomeHUD.CLIENT.f_91073_.m_46472_());
        int color = BiomeHUD.getTextColorFromDimension(dimensionIndex) | 0xFF000000;
        int xTemp = this.x - BiomeHUD.BIOME_SETTINGS.base.growthDirectionX.getGrowthDirection(cachedTextWidth);
        RenderUtils.drawTextureHUD(context, DIMENSION_TEXTURE, xTemp, this.y, 0.0f, dimensionIndex * 13, 13, 13, 13, 52);
        RenderUtils.fillRoundedRightSide(context, xTemp + 14, this.y, xTemp + 14 + cachedTextWidth + 9, this.y + 13, Integer.MIN_VALUE);
        RenderUtils.drawTextHUD(context, cachedBiomeNameText.m_7532_(), xTemp + 19, this.y + 3, color, false);
        this.setBoundingBox(xTemp, this.y, 14 + cachedTextWidth + 9, 13, color);
        return true;
    }

    private static String getBiomeIdAsString(Holder<Biome> biome) {
        return (String)biome.m_203439_().map(biomeKey -> biomeKey.m_135782_().toString(), biome_ -> "[unregistered " + String.valueOf(biome_) + "]");
    }

    private static int getDimensionIndex(ResourceKey<Level> registryKey) {
        if (registryKey == Level.f_46428_) {
            return 0;
        }
        if (registryKey == Level.f_46429_) {
            return 1;
        }
        if (registryKey == Level.f_46430_) {
            return 2;
        }
        return 3;
    }

    private static int getTextColorFromDimension(int dimensionIndex) {
        return switch (dimensionIndex) {
            case 0 -> BiomeHUD.BIOME_SETTINGS.color.overworld;
            case 1 -> BiomeHUD.BIOME_SETTINGS.color.nether;
            case 2 -> BiomeHUD.BIOME_SETTINGS.color.end;
            default -> BiomeHUD.BIOME_SETTINGS.color.custom;
        };
    }

    @Override
    public int getBaseHUDWidth() {
        return 24;
    }

    @Override
    public int getBaseHUDHeight() {
        return 13;
    }

    static {
        CLIENT = Minecraft.m_91087_();
    }
}

