/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.hud.implementation;

import fin.starhud.Main;
import fin.starhud.config.hud.DirectionSettings;
import fin.starhud.helper.RenderUtils;
import fin.starhud.hud.AbstractHUD;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class DirectionHUD
extends AbstractHUD {
    private static final DirectionSettings DIRECTION_SETTINGS = Main.settings.directionSettings;
    private static final ResourceLocation DIRECTION_CARDINAL_TEXTURE = ResourceLocation.m_214293_((String)"starhud", (String)"hud/direction.png");
    private static final ResourceLocation DIRECTION_ORDINAL_TEXTURE = ResourceLocation.m_214293_((String)"starhud", (String)"hud/direction_ordinal.png");
    private static final int TEXTURE_HEIGHT = 13;
    private static final int TEXTURE_CARDINAL_WIDTH = 55;
    private static final int TEXTURE_ORDINAL_WIDTH = 61;
    private static final int CARDINAL_ICON_AMOUNT = 4;
    private static final int ORDINAL_ICON_AMOUNT = 8;
    private static final int CARDINAL_TEXT_OFFSET = 19;
    private static final int ORDINAL_TEXT_OFFSET = 25;
    private static final Minecraft CLIENT = Minecraft.m_91087_();

    public DirectionHUD() {
        super(DirectionHUD.DIRECTION_SETTINGS.base);
    }

    @Override
    public String getName() {
        return "Direction HUD";
    }

    @Override
    public boolean renderHUD(GuiGraphics context) {
        float yaw = (float)Math.round(Mth.m_14177_((float)DirectionHUD.CLIENT.f_91075_.m_146908_()) * 10.0f) / 10.0f;
        if (DirectionHUD.DIRECTION_SETTINGS.includeOrdinal) {
            int icon = DirectionHUD.getOrdinalDirectionIcon(yaw);
            int color = DirectionHUD.getDirectionColor(icon) | 0xFF000000;
            RenderUtils.drawTextureHUD(context, DIRECTION_ORDINAL_TEXTURE, this.x, this.y, 0.0f, icon * 13, 61, 13, 61, 104, color);
            RenderUtils.drawTextHUD(context, Float.toString(yaw), this.x + 25, this.y + 3, color, false);
            this.setBoundingBox(this.x, this.y, 61, 13, color);
        } else {
            int icon = DirectionHUD.getCardinalDirectionIcon(yaw);
            int color = DirectionHUD.getDirectionColor(icon * 2) | 0xFF000000;
            RenderUtils.drawTextureHUD(context, DIRECTION_CARDINAL_TEXTURE, this.x, this.y, 0.0f, icon * 13, 55, 13, 55, 52, color);
            RenderUtils.drawTextHUD(context, Float.toString(yaw), this.x + 19, this.y + 3, color, false);
            this.setBoundingBox(this.x, this.y, 55, 13, color);
        }
        return true;
    }

    private static int getOrdinalDirectionIcon(float yaw) {
        if (-22.5 <= (double)yaw && (double)yaw < 22.5) {
            return 0;
        }
        if (22.5 <= (double)yaw && (double)yaw < 67.5) {
            return 1;
        }
        if (67.5 <= (double)yaw && (double)yaw < 112.5) {
            return 2;
        }
        if (112.5 <= (double)yaw && (double)yaw < 157.5) {
            return 3;
        }
        if (157.5 <= (double)yaw || (double)yaw < -157.5) {
            return 4;
        }
        if (-157.5 <= (double)yaw && (double)yaw < -112.5) {
            return 5;
        }
        if (-112.5 <= (double)yaw && (double)yaw < -67.5) {
            return 6;
        }
        if (-67.5 <= (double)yaw && (double)yaw < -22.5) {
            return 7;
        }
        return 0;
    }

    private static int getCardinalDirectionIcon(float yaw) {
        if (-45.0 <= (double)yaw && (double)yaw < 45.0) {
            return 0;
        }
        if (45.0 <= (double)yaw && (double)yaw < 135.0) {
            return 1;
        }
        if (135.0 <= (double)yaw || (double)yaw < -135.0) {
            return 2;
        }
        if (-135.0 <= (double)yaw && (double)yaw < -45.0) {
            return 3;
        }
        return 0;
    }

    private static int getDirectionColor(int icon) {
        return switch (icon) {
            case 0 -> DirectionHUD.DIRECTION_SETTINGS.directionColor.s;
            case 1 -> DirectionHUD.DIRECTION_SETTINGS.directionColor.sw;
            case 2 -> DirectionHUD.DIRECTION_SETTINGS.directionColor.w;
            case 3 -> DirectionHUD.DIRECTION_SETTINGS.directionColor.nw;
            case 4 -> DirectionHUD.DIRECTION_SETTINGS.directionColor.n;
            case 5 -> DirectionHUD.DIRECTION_SETTINGS.directionColor.ne;
            case 6 -> DirectionHUD.DIRECTION_SETTINGS.directionColor.e;
            case 7 -> DirectionHUD.DIRECTION_SETTINGS.directionColor.se;
            default -> 0xFFFFFF;
        };
    }

    @Override
    public int getBaseHUDWidth() {
        return DirectionHUD.DIRECTION_SETTINGS.includeOrdinal ? 61 : 55;
    }

    @Override
    public int getBaseHUDHeight() {
        return 13;
    }
}

