/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.hud.implementation;

import fin.starhud.Helper;
import fin.starhud.Main;
import fin.starhud.config.hud.EffectSettings;
import fin.starhud.helper.Box;
import fin.starhud.helper.RenderUtils;
import fin.starhud.helper.ScreenAlignmentX;
import fin.starhud.helper.ScreenAlignmentY;
import fin.starhud.helper.StatusEffectAttribute;
import fin.starhud.hud.AbstractHUD;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.registries.ForgeRegistries;

public class EffectHUD
extends AbstractHUD {
    private static final EffectSettings effectSettings = Main.settings.effectSettings;
    private static final Minecraft CLIENT = Minecraft.m_91087_();
    private static final ResourceLocation STATUS_EFFECT_BACKGROUND_TEXTURE = ResourceLocation.m_214293_((String)"starhud", (String)"hud/effect.png");
    private static final ResourceLocation STATUS_EFFECT_BAR_TEXTURE = ResourceLocation.m_214293_((String)"starhud", (String)"hud/effect_bar.png");
    private static final ResourceLocation STATUS_EFFECT_AMBIENT_TEXTURE = ResourceLocation.m_214293_((String)"starhud", (String)"hud/effect_ambient.png");
    private static final int STATUS_EFFECT_TEXTURE_WIDTH = 24;
    private static final int STATUS_EFFECT_TEXTURE_HEIGHT = 32;
    private static final int STATUS_EFFECT_BAR_TEXTURE_WIDTH = 21;
    private static final int STATUS_EFFECT_BAR_TEXTURE_HEIGHT = 3;
    private static final Map<MobEffect, ResourceLocation> STATUS_EFFECT_TEXTURE_MAP = new HashMap<MobEffect, ResourceLocation>();
    private static final Box tempBox = new Box(0, 0);
    private static int cachedSize = -1;
    private static boolean needBoxUpdate = true;

    public EffectHUD() {
        super(EffectHUD.effectSettings.base);
    }

    @Override
    public String getName() {
        return "Status Effect HUD";
    }

    @Override
    public boolean shouldRender() {
        return super.shouldRender() && !EffectHUD.CLIENT.f_91074_.m_21220_().isEmpty();
    }

    @Override
    public void update() {
        super.update();
        needBoxUpdate = true;
        this.boundingBox.setEmpty(true);
    }

    @Override
    public boolean renderHUD(GuiGraphics context) {
        boolean shouldBoxUpdate;
        Collection collection = EffectHUD.CLIENT.f_91074_.m_21220_();
        int beneficialIndex = 0;
        int harmIndex = 0;
        boolean drawVertical = EffectHUD.effectSettings.drawVertical;
        int sameTypeGap = EffectHUD.effectSettings.sameTypeGap;
        int differentTypeGap = drawVertical && EffectHUD.effectSettings.base.originX == ScreenAlignmentX.RIGHT || !drawVertical && EffectHUD.effectSettings.base.originY == ScreenAlignmentY.BOTTOM ? -EffectHUD.effectSettings.differentTypeGap : EffectHUD.effectSettings.differentTypeGap;
        int effectSize = collection.size();
        int beneficialSize = EffectHUD.getBeneficialSize();
        int harmSize = effectSize - beneficialSize;
        int xBeneficial = this.x - EffectHUD.effectSettings.base.growthDirectionX.getGrowthDirection(this.getDynamicWidth(true, beneficialSize, harmSize));
        int yBeneficial = this.y - EffectHUD.effectSettings.base.growthDirectionY.getGrowthDirection(this.getDynamicHeight(true, beneficialSize, harmSize));
        int xHarm = beneficialSize == 0 && drawVertical ? xBeneficial : this.x - EffectHUD.effectSettings.base.growthDirectionX.getGrowthDirection(this.getDynamicWidth(false, beneficialSize, harmSize));
        int yHarm = beneficialSize == 0 && !drawVertical ? yBeneficial : this.y - EffectHUD.effectSettings.base.growthDirectionY.getGrowthDirection(this.getDynamicHeight(false, beneficialSize, harmSize));
        boolean bl = shouldBoxUpdate = needBoxUpdate || cachedSize != StatusEffectAttribute.getStatusEffectAttributeMap().size();
        if (shouldBoxUpdate) {
            cachedSize = StatusEffectAttribute.getStatusEffectAttributeMap().size();
        }
        for (MobEffectInstance statusEffectInstance : collection) {
            int color;
            int step;
            int y2;
            int x2;
            if (!statusEffectInstance.m_19575_()) continue;
            MobEffect statusEffect = statusEffectInstance.m_19544_();
            StatusEffectAttribute statusEffectAttribute = StatusEffectAttribute.getStatusEffectAttribute(statusEffectInstance);
            if (statusEffect.m_19486_()) {
                x2 = xBeneficial + (drawVertical ? 0 : sameTypeGap) * beneficialIndex;
                y2 = yBeneficial + (drawVertical ? sameTypeGap : 0) * beneficialIndex;
                ++beneficialIndex;
            } else {
                x2 = xHarm + (beneficialSize == 0 ? 0 : (drawVertical ? differentTypeGap : 0)) + (drawVertical ? 0 : sameTypeGap) * harmIndex;
                y2 = yHarm + (beneficialSize == 0 ? 0 : (drawVertical ? 0 : differentTypeGap)) + (drawVertical ? sameTypeGap : 0) * harmIndex;
                ++harmIndex;
            }
            if (shouldBoxUpdate) {
                tempBox.setBoundingBox(x2, y2, 24, 32);
                if (this.boundingBox.isEmpty()) {
                    this.boundingBox.setBoundingBox(tempBox.getX(), tempBox.getY(), tempBox.width(), tempBox.getHeight(), EffectHUD.effectSettings.ambientColor | 0xFF000000);
                } else {
                    this.boundingBox.mergeWith(tempBox);
                }
            }
            if (statusEffectInstance.m_19571_()) {
                RenderUtils.drawTextureHUD(context, STATUS_EFFECT_AMBIENT_TEXTURE, x2, y2, 0.0f, 0.0f, 24, 32, 24, 32, EffectHUD.effectSettings.ambientColor | 0xFF000000);
            } else {
                RenderUtils.drawTextureHUD(context, STATUS_EFFECT_BACKGROUND_TEXTURE, x2, y2, 0.0f, 0.0f, 24, 32, 24, 32);
            }
            int duration = statusEffectInstance.m_19557_();
            if (statusEffectInstance.m_267577_()) {
                step = 7;
                color = EffectHUD.effectSettings.infiniteColor | 0xFF000000;
            } else {
                int maxDuration = statusEffectAttribute.maxDuration();
                step = Helper.getStep(duration, maxDuration, 7);
                color = (EffectHUD.effectSettings.useEffectColor ? statusEffect.m_19484_() : RenderUtils.getItemBarColor(step, 7)) | 0xFF000000;
            }
            RenderUtils.drawTextureHUD(context, STATUS_EFFECT_BAR_TEXTURE, x2 + 2, y2 + 27, 0.0f, 0.0f, 3 * step, 3, 21, 3, color);
            float alpha = 1.0f;
            if (duration <= 200 && !statusEffectInstance.m_267577_()) {
                int n = 10 - duration / 20;
                alpha = Mth.m_14036_((float)((float)duration / 10.0f / 5.0f * 0.5f), (float)0.0f, (float)0.5f) + Mth.m_14089_((float)((float)duration * (float)Math.PI / 5.0f)) * Mth.m_14036_((float)((float)n / 10.0f * 0.25f), (float)0.0f, (float)0.25f);
                alpha = Mth.m_14036_((float)alpha, (float)0.0f, (float)1.0f);
            }
            RenderUtils.drawTextureHUD(context, EffectHUD.getStatusEffectTexture(statusEffect), x2 + 3, y2 + 3, 0.0f, 0.0f, 18, 18, 18, 18, Math.round(alpha * 255.0f) << 24 | 0xFFFFFF);
            int amplifier = statusEffectAttribute.amplifier() + 1;
            if (amplifier == 1) continue;
            String amplifierStr = Helper.toSubscript(Integer.toString(amplifier));
            RenderUtils.drawTextHUD(context, amplifierStr, x2 + 3 + 18 - EffectHUD.CLIENT.f_91062_.m_92895_(amplifierStr) + 1, y2 + 2 + 18 - 7, -1, true);
        }
        needBoxUpdate = false;
        return true;
    }

    public int getDynamicWidth(boolean isBeneficial, int beneficialSize, int harmSize) {
        return EffectHUD.effectSettings.drawVertical ? 24 : (isBeneficial ? beneficialSize : harmSize) * EffectHUD.effectSettings.sameTypeGap;
    }

    public int getDynamicHeight(boolean isBeneficial, int beneficialSize, int harmSize) {
        return EffectHUD.effectSettings.drawVertical ? (isBeneficial ? beneficialSize : harmSize) * EffectHUD.effectSettings.sameTypeGap : 32;
    }

    public static int getBeneficialSize() {
        int size = 0;
        for (MobEffectInstance collection : EffectHUD.CLIENT.f_91074_.m_21220_()) {
            if (!collection.m_19544_().m_19486_()) continue;
            ++size;
        }
        return size;
    }

    @Override
    public int getBaseHUDWidth() {
        return 0;
    }

    @Override
    public int getBaseHUDHeight() {
        return 0;
    }

    public static ResourceLocation getStatusEffectTexture(MobEffect effect) {
        return STATUS_EFFECT_TEXTURE_MAP.computeIfAbsent(effect, e -> {
            ResourceLocation id = ForgeRegistries.MOB_EFFECTS.getKey(e);
            return ResourceLocation.m_214293_((String)id.m_135827_(), (String)("textures/mob_effect/" + id.m_135815_() + ".png"));
        });
    }
}

