/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.hud.implementation;

import fin.starhud.Main;
import fin.starhud.config.hud.PingSettings;
import fin.starhud.helper.RenderUtils;
import fin.starhud.hud.AbstractHUD;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.resources.ResourceLocation;

public class PingHUD
extends AbstractHUD {
    private static final PingSettings PING_SETTINGS = Main.settings.pingSettings;
    private static final ResourceLocation PING_TEXTURE = ResourceLocation.m_214293_((String)"starhud", (String)"hud/ping.png");
    private static final int TEXTURE_WIDTH = 63;
    private static final int TEXTURE_HEIGHT = 13;
    private static final Minecraft CLIENT = Minecraft.m_91087_();

    public PingHUD() {
        super(PingHUD.PING_SETTINGS.base);
    }

    @Override
    public String getName() {
        return "Ping HUD";
    }

    @Override
    public boolean shouldRender() {
        return super.shouldRender() && !CLIENT.m_91090_() && CLIENT.m_91403_() != null && CLIENT.m_91403_().m_104949_(PingHUD.CLIENT.f_91074_.m_20148_()) != null;
    }

    @Override
    public boolean renderHUD(GuiGraphics context) {
        PlayerInfo playerListEntry = CLIENT.m_91403_().m_104949_(PingHUD.CLIENT.f_91074_.m_20148_());
        int currentPing = playerListEntry.m_105330_();
        String pingStr = currentPing + " ms";
        int step = Math.min(currentPing / 150, 3);
        int color = PingHUD.getPingColor(step) | 0xFF000000;
        RenderUtils.drawTextureHUD(context, PING_TEXTURE, this.x, this.y, 0.0f, step * 13, 63, 13, 63, 52, color);
        RenderUtils.drawTextHUD(context, pingStr, this.x + 19, this.y + 3, color, false);
        this.setBoundingBox(this.x, this.y, 63, 13, color);
        return true;
    }

    public static int getPingColor(int step) {
        return switch (step) {
            case 0 -> PingHUD.PING_SETTINGS.pingColor.first;
            case 1 -> PingHUD.PING_SETTINGS.pingColor.second;
            case 2 -> PingHUD.PING_SETTINGS.pingColor.third;
            case 3 -> PingHUD.PING_SETTINGS.pingColor.fourth;
            default -> -1;
        };
    }

    @Override
    public int getBaseHUDWidth() {
        return 63;
    }

    @Override
    public int getBaseHUDHeight() {
        return 13;
    }
}

