/*
 * Decompiled with CFR 0.152.
 */
package pl.flezy.itemsblocker;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffectType;
import pl.flezy.itemsblocker.commands.BlockCommand;
import pl.flezy.itemsblocker.config.ConfigurationFactory;
import pl.flezy.itemsblocker.config.DataConfiguration;
import pl.flezy.itemsblocker.libs.acf.PaperCommandManager;
import pl.flezy.itemsblocker.listeners.BlockListener;

public final class ItemsBlocker
extends JavaPlugin {
    private final File dataConfigurationFile = new File(this.getDataFolder(), "data.yml");
    private DataConfiguration dataConfiguration;
    private static ItemsBlocker instance;

    public void onEnable() {
        instance = this;
        this.dataConfiguration = ConfigurationFactory.createDataConfiguration(this.dataConfigurationFile);
        this.registerCommands();
        this.registerListeners(List.of(new BlockListener()));
    }

    private void registerCommands() {
        PaperCommandManager manager = new PaperCommandManager((Plugin)this);
        manager.enableUnstableAPI("help");
        manager.getCommandCompletions().registerCompletion("enchantments", c -> Registry.ENCHANTMENT.stream().map(Enchantment::getKey).map(NamespacedKey::getKey).collect(Collectors.toSet()));
        manager.getCommandCompletions().registerCompletion("potionEffects", c -> Registry.POTION_EFFECT_TYPE.stream().map(PotionEffectType::getKey).map(NamespacedKey::getKey).collect(Collectors.toSet()));
        manager.getCommandCompletions().registerCompletion("enchantmentsRemove", c -> this.dataConfiguration.blockedEnchants.keySet().stream().map(Enchantment::getKey).map(NamespacedKey::getKey).collect(Collectors.toSet()));
        manager.getCommandCompletions().registerCompletion("potionEffectsRemove", c -> this.dataConfiguration.blockedPotions.keySet().stream().map(PotionEffectType::getKey).map(NamespacedKey::getKey).collect(Collectors.toSet()));
        manager.getCommandCompletions().registerCompletion("itemsRemove", c -> this.dataConfiguration.blockedMaterials.stream().map(Enum::name).collect(Collectors.toSet()));
        manager.registerCommand(new BlockCommand());
    }

    private void registerListeners(List<Listener> listeners) {
        listeners.forEach(listener -> this.getServer().getPluginManager().registerEvents(listener, (Plugin)this));
    }

    public static ItemsBlocker instance() {
        return instance;
    }

    public DataConfiguration dataConfiguration() {
        return this.dataConfiguration;
    }

    public void reloadConfiguration() {
        this.dataConfiguration.load();
    }
}

