/*
 * Decompiled with CFR 0.152.
 */
package pl.flezy.itemsblocker.libs.eu.okaeri.placeholders.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import pl.flezy.itemsblocker.libs.eu.okaeri.placeholders.message.part.MessageElement;
import pl.flezy.itemsblocker.libs.eu.okaeri.placeholders.message.part.MessageField;
import pl.flezy.itemsblocker.libs.eu.okaeri.placeholders.message.part.MessageStatic;

public class CompiledMessage {
    private static final Pattern FIELD_PATTERN = Pattern.compile("\\{(?<content>[^}]+)\\}");
    private final String raw;
    private final List<MessageElement> parts;
    private final Set<String> usedFields;

    public static CompiledMessage of(@NonNull String raw, @NonNull List<MessageElement> parts) {
        if (raw == null) {
            throw new NullPointerException("raw is marked non-null but is null");
        }
        if (parts == null) {
            throw new NullPointerException("parts is marked non-null but is null");
        }
        HashSet<String> usedFields = new HashSet<String>();
        for (MessageElement part : parts) {
            if (!(part instanceof MessageField)) continue;
            MessageField field = (MessageField)part;
            String fieldName = field.getName();
            usedFields.add(fieldName);
            usedFields.add(fieldName.split("(\\.|\\()", 2)[0]);
        }
        return new CompiledMessage(raw, parts, usedFields);
    }

    public static CompiledMessage of(@NonNull String source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return CompiledMessage.of(Locale.ENGLISH, source);
    }

    public static CompiledMessage of(@NonNull Locale locale, @NonNull String source) {
        boolean withFields;
        if (locale == null) {
            throw new NullPointerException("locale is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (source.isEmpty()) {
            return new CompiledMessage(source, Collections.emptyList(), Collections.emptySet());
        }
        Matcher matcher = FIELD_PATTERN.matcher(source);
        ArrayList<MessageElement> parts = new ArrayList<MessageElement>();
        HashSet<String> usedFields = new HashSet<String>();
        int lastIndex = 0;
        int rawLength = source.length();
        int fieldsLength = 0;
        while (matcher.find()) {
            parts.add(MessageStatic.of(source.substring(lastIndex, matcher.start())));
            String content = matcher.group("content");
            String[] fieldElements = CompiledMessage.parseFieldToArray(content);
            String metaElement = fieldElements[0];
            String fieldName = fieldElements[1];
            String defaultValue = fieldElements[2];
            MessageField messageField = MessageField.of(locale, fieldName);
            messageField.setDefaultValue(defaultValue);
            messageField.setMetadataRaw(metaElement);
            messageField.setRaw(content);
            parts.add(messageField);
            usedFields.add(fieldName);
            usedFields.add(fieldName.split("(\\.|\\()", 2)[0]);
            lastIndex = matcher.end();
            fieldsLength += matcher.group().length();
        }
        if (lastIndex != source.length()) {
            parts.add(MessageStatic.of(source.substring(lastIndex)));
        }
        boolean bl = withFields = fieldsLength > 0;
        if (!withFields && parts.size() > 1) {
            throw new RuntimeException("noticed message without fields with more than one element: " + parts);
        }
        return new CompiledMessage(source, Collections.unmodifiableList(parts), Collections.unmodifiableSet(usedFields));
    }

    private static String[] parseFieldToArray(@NonNull String raw) {
        if (raw == null) {
            throw new NullPointerException("raw is marked non-null but is null");
        }
        String[] arr = new String[3];
        int commentIndex = raw.indexOf("#");
        if (commentIndex != -1) {
            arr[0] = raw.substring(0, commentIndex);
            raw = raw.substring(commentIndex + 1);
        }
        int fallbackIndex = raw.lastIndexOf("|");
        int argumentsEndIndex = raw.lastIndexOf(")");
        if (fallbackIndex != -1 && fallbackIndex > argumentsEndIndex) {
            arr[2] = raw.substring(fallbackIndex + 1);
            raw = raw.substring(0, fallbackIndex);
        }
        arr[1] = raw;
        return arr;
    }

    public boolean hasField(@Nullable String name) {
        return this.usedFields.contains(name);
    }

    public boolean isWithFields() {
        return !this.usedFields.isEmpty();
    }

    public String getRaw() {
        return this.raw;
    }

    public List<MessageElement> getParts() {
        return this.parts;
    }

    public Set<String> getUsedFields() {
        return this.usedFields;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompiledMessage)) {
            return false;
        }
        CompiledMessage other = (CompiledMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$raw = this.getRaw();
        String other$raw = other.getRaw();
        if (this$raw == null ? other$raw != null : !this$raw.equals(other$raw)) {
            return false;
        }
        List<MessageElement> this$parts = this.getParts();
        List<MessageElement> other$parts = other.getParts();
        if (this$parts == null ? other$parts != null : !((Object)this$parts).equals(other$parts)) {
            return false;
        }
        Set<String> this$usedFields = this.getUsedFields();
        Set<String> other$usedFields = other.getUsedFields();
        return !(this$usedFields == null ? other$usedFields != null : !((Object)this$usedFields).equals(other$usedFields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CompiledMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $raw = this.getRaw();
        result = result * 59 + ($raw == null ? 43 : $raw.hashCode());
        List<MessageElement> $parts = this.getParts();
        result = result * 59 + ($parts == null ? 43 : ((Object)$parts).hashCode());
        Set<String> $usedFields = this.getUsedFields();
        result = result * 59 + ($usedFields == null ? 43 : ((Object)$usedFields).hashCode());
        return result;
    }

    public String toString() {
        return "CompiledMessage(raw=" + this.getRaw() + ", parts=" + this.getParts() + ", usedFields=" + this.getUsedFields() + ")";
    }

    private CompiledMessage(String raw, List<MessageElement> parts, Set<String> usedFields) {
        this.raw = raw;
        this.parts = parts;
        this.usedFields = usedFields;
    }
}

