/*
 * Decompiled with CFR 0.152.
 */
package pl.flezy.itemsblocker.libs.eu.okaeri.placeholders.schema.meta;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import pl.flezy.itemsblocker.libs.eu.okaeri.placeholders.schema.annotation.Placeholder;
import pl.flezy.itemsblocker.libs.eu.okaeri.placeholders.schema.resolver.PlaceholderResolver;

public class SchemaMeta {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final Map<Class<?>, SchemaMeta> SCHEMA_CACHE = new ConcurrentHashMap();
    private final Class<?> type;
    private final Map<String, PlaceholderResolver> placeholders;

    public static SchemaMeta of(@NonNull Class<?> clazz) {
        MethodHandle handle;
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        SchemaMeta cached = SCHEMA_CACHE.get(clazz);
        if (cached != null) {
            return cached;
        }
        LinkedHashMap<String, PlaceholderResolver> placeholders = new LinkedHashMap<String, PlaceholderResolver>();
        Field[] fields = clazz.getDeclaredFields();
        Method[] methods = clazz.getDeclaredMethods();
        Placeholder clazzAnnotation = clazz.getAnnotation(Placeholder.class);
        if (clazzAnnotation != null && clazzAnnotation.scan()) {
            for (AccessibleObject accessibleObject : methods) {
                if (!Modifier.isPublic(((Method)accessibleObject).getModifiers())) continue;
                if (!clazzAnnotation.name().isEmpty()) {
                    throw new RuntimeException("@Placeholder for " + clazz + " has name set, names are not supported here");
                }
                String name = ((Method)accessibleObject).getName();
                if (name.startsWith("get")) {
                    name = name.substring(3);
                } else {
                    if (!name.startsWith("is")) continue;
                    name = name.substring(2);
                }
                char[] nameArr = name.toCharArray();
                nameArr[0] = Character.toLowerCase(nameArr[0]);
                name = new String(nameArr);
                Class<?> returnType = ((Method)accessibleObject).getReturnType();
                handle = SchemaMeta.toHandle((Method)accessibleObject);
                placeholders.put(name, (from, params, context) -> SchemaMeta.handleholder(handle, from));
            }
        }
        for (AccessibleObject accessibleObject : fields) {
            Class<?> fieldType = ((Field)accessibleObject).getType();
            Placeholder placeholder = ((Field)accessibleObject).getAnnotation(Placeholder.class);
            if (placeholder == null) continue;
            String name = placeholder.name().isEmpty() ? ((Field)accessibleObject).getName() : placeholder.name();
            handle = SchemaMeta.toHandle((Field)accessibleObject);
            placeholders.put(name, (from, params, context) -> SchemaMeta.handleholder(handle, from));
        }
        for (AccessibleObject accessibleObject : methods) {
            Placeholder placeholder = ((Method)accessibleObject).getAnnotation(Placeholder.class);
            if (placeholder == null) continue;
            String name = placeholder.name().isEmpty() ? ((Method)accessibleObject).getName() : placeholder.name();
            MethodHandle handle2 = SchemaMeta.toHandle((Method)accessibleObject);
            placeholders.put(name, (from, params, context) -> SchemaMeta.handleholder(handle2, from));
        }
        SchemaMeta meta = new SchemaMeta(clazz, placeholders);
        SCHEMA_CACHE.put(clazz, meta);
        return meta;
    }

    private static Object handleholder(MethodHandle handle, Object from) {
        return handle.invoke(from);
    }

    private static MethodHandle toHandle(Method method) {
        method.setAccessible(true);
        return LOOKUP.unreflect(method);
    }

    private static MethodHandle toHandle(Field field) {
        field.setAccessible(true);
        return LOOKUP.unreflectGetter(field);
    }

    public Class<?> getType() {
        return this.type;
    }

    public Map<String, PlaceholderResolver> getPlaceholders() {
        return this.placeholders;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaMeta)) {
            return false;
        }
        SchemaMeta other = (SchemaMeta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<?> this$type = this.getType();
        Class<?> other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Map<String, PlaceholderResolver> this$placeholders = this.getPlaceholders();
        Map<String, PlaceholderResolver> other$placeholders = other.getPlaceholders();
        return !(this$placeholders == null ? other$placeholders != null : !((Object)this$placeholders).equals(other$placeholders));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SchemaMeta;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Map<String, PlaceholderResolver> $placeholders = this.getPlaceholders();
        result = result * 59 + ($placeholders == null ? 43 : ((Object)$placeholders).hashCode());
        return result;
    }

    public String toString() {
        return "SchemaMeta(type=" + this.getType() + ", placeholders=" + this.getPlaceholders() + ")";
    }

    private SchemaMeta(Class<?> type, Map<String, PlaceholderResolver> placeholders) {
        this.type = type;
        this.placeholders = placeholders;
    }
}

