/*
 * Decompiled with CFR 0.152.
 */
package pl.flezy.itemsblocker.libs.eu.okaeri.validator;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.NonNull;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.ConstraintViolation;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.Validator;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.policy.NullPolicy;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.provider.DecimalMaxProvider;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.provider.DecimalMinProvider;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.provider.MaxProvider;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.provider.MinProvider;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.provider.NegativeOrZeroProvider;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.provider.NegativeProvider;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.provider.NotBlankProvider;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.provider.NotNullProvider;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.provider.PatternProvider;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.provider.PositiveOrZeroProvider;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.provider.PositiveProvider;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.provider.SizeProvider;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.provider.ValidationProvider;

public class OkaeriValidator
implements Validator {
    private final Map<Class<? extends Annotation>, ValidationProvider<?>> validationProviders = new ConcurrentHashMap();

    protected OkaeriValidator(NullPolicy nullPolicy) {
        this.register((ValidationProvider)new DecimalMaxProvider());
        this.register((ValidationProvider)new DecimalMinProvider());
        this.register((ValidationProvider)new MaxProvider());
        this.register((ValidationProvider)new MinProvider());
        this.register((ValidationProvider)new NegativeOrZeroProvider());
        this.register((ValidationProvider)new NegativeProvider());
        this.register((ValidationProvider)new NotBlankProvider());
        this.register((ValidationProvider)new NotNullProvider(nullPolicy));
        this.register((ValidationProvider)new PatternProvider());
        this.register((ValidationProvider)new PositiveOrZeroProvider());
        this.register((ValidationProvider)new PositiveProvider());
        this.register((ValidationProvider)new SizeProvider());
    }

    public static OkaeriValidator of() {
        return OkaeriValidator.of(NullPolicy.NULLABLE);
    }

    public static OkaeriValidator of(NullPolicy nullPolicy) {
        return new OkaeriValidator(nullPolicy);
    }

    @Override
    public <T extends Annotation> OkaeriValidator register(@NonNull ValidationProvider<T> validationProvider) {
        if (validationProvider == null) {
            throw new NullPointerException("validationProvider is marked non-null but is null");
        }
        this.validationProviders.put(validationProvider.getAnnotation(), validationProvider);
        return this;
    }

    @Override
    public Set<ConstraintViolation> validate(@NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        return Arrays.stream(object.getClass().getDeclaredFields()).flatMap(field -> this.validateProperty(object, (Field)field).stream()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public Set<ConstraintViolation> validateProperty(@NonNull Object object, @NonNull String fieldName) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        return this.validateProperty(object, object.getClass().getDeclaredField(fieldName));
    }

    @Override
    public Set<ConstraintViolation> validateProperty(@NonNull Object object, @NonNull Field field) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        field.setAccessible(true);
        Object value = field.get(object);
        return this.validatePropertyValue(object.getClass(), field, value);
    }

    @Override
    public Set<ConstraintViolation> validatePropertyValue(@NonNull Class<?> type, @NonNull String fieldName, Object fieldValue) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        return this.validatePropertyValue(type, type.getDeclaredField(fieldName), fieldValue);
    }

    @Override
    public Set<ConstraintViolation> validatePropertyValue(@NonNull Class<?> type, @NonNull Field field, Object fieldValue) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return this.validationProviders.values().stream().filter(provider -> provider.shouldValidate(field)).flatMap(provider -> provider.validate(field, fieldValue).stream()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public Set<ConstraintViolation> validateParameters(@NonNull Parameter[] parameters, @NonNull Object[] values) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return IntStream.range(0, parameters.length).mapToObj(i -> this.validateParameter(parameters[i], values[i])).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public Set<ConstraintViolation> validateParameter(@NonNull Parameter parameter, @NonNull Object value) {
        if (parameter == null) {
            throw new NullPointerException("parameter is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.validationProviders.values().stream().filter(provider -> provider.shouldValidate(parameter)).flatMap(provider -> provider.validate(parameter, value).stream()).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

