/*
 * Decompiled with CFR 0.152.
 */
package pl.flezy.itemsblocker.libs.eu.okaeri.validator.provider;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.ConstraintViolation;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.annotation.NotNull;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.annotation.Nullable;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.annotation.Size;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.exception.ValidatorException;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.provider.ValidationProvider;

public class SizeProvider
implements ValidationProvider<Size> {
    @Override
    public Class<Size> getAnnotation() {
        return Size.class;
    }

    @Override
    public Set<ConstraintViolation> validate(@NotNull Size annotation, @Nullable Object annotationSource, @Nullable Object value, @NotNull Class<?> type, @NotNull Type genericType, @NotNull String name) {
        type = this.extractType(type, genericType);
        value = this.extractValue(value, type, genericType);
        if (value == null) {
            return Collections.emptySet();
        }
        Integer size = null;
        if (Collection.class.isAssignableFrom(type)) {
            size = ((Collection)value).size();
        } else if (Map.class.isAssignableFrom(type)) {
            size = ((Map)value).size();
        } else if (CharSequence.class.isAssignableFrom(type)) {
            size = ((CharSequence)value).length();
        } else if (type.isArray()) {
            size = ((Object[])value).length;
        }
        if (size == null) {
            throw new ValidatorException("@Size is not applicable for " + type + " [" + name + "]");
        }
        int min = annotation.min();
        int max = annotation.max();
        if (size >= min && size <= max) {
            return Collections.emptySet();
        }
        String message = annotation.message().replace("{min}", String.valueOf(min)).replace("{max}", String.valueOf(max));
        LinkedHashSet<ConstraintViolation> violations = new LinkedHashSet<ConstraintViolation>();
        violations.add(new ConstraintViolation(name, message, this.getType()));
        return violations;
    }
}

