/*
 * Decompiled with CFR 0.152.
 */
package pl.flezy.itemsblocker.listeners;

import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.VillagerAcquireTradeEvent;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.inventory.SmithItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import pl.flezy.itemsblocker.ItemsBlocker;

public class BlockListener
implements Listener {
    private final ItemsBlocker plugin = ItemsBlocker.instance();

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        ItemStack item = event.getItem();
        if (this.checkItem(item)) {
            item.setAmount(0);
        }
    }

    @EventHandler
    public void onCraft(PrepareItemCraftEvent event) {
        ItemStack item = event.getInventory().getResult();
        if (this.checkItem(item)) {
            event.getInventory().setResult(null);
        }
    }

    @EventHandler
    public void onBrew(BrewEvent event) {
        List items = event.getResults();
        for (ItemStack item : items) {
            if (!this.checkItem(item)) continue;
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onTrade(VillagerAcquireTradeEvent event) {
        ItemStack item = event.getRecipe().getResult();
        if (this.checkItem(item)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Player player;
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player && (player = (Player)humanEntity).hasPermission("itemsblocker.bypass")) {
            return;
        }
        ItemStack item = event.getCurrentItem();
        if (this.checkItem(item)) {
            item.setAmount(0);
        }
    }

    @EventHandler
    public void onSwapItems(PlayerSwapHandItemsEvent event) {
        if (event.getPlayer().hasPermission("itemsblocker.bypass")) {
            return;
        }
        ItemStack item = event.getOffHandItem();
        if (this.checkItem(item)) {
            item.setAmount(0);
        }
    }

    @EventHandler
    public void onEntityPickUp(EntityPickupItemEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).hasPermission("itemsblocker.bypass")) {
            return;
        }
        ItemStack item = event.getItem().getItemStack();
        if (this.checkItem(item)) {
            event.getItem().remove();
        }
    }

    @EventHandler
    public void onEnchant(EnchantItemEvent event) {
        if (this.checkEnchant(event.getEnchantsToAdd())) {
            event.setCancelled(true);
        }
    }

    private boolean checkItem(ItemStack item) {
        PotionMeta pm;
        EnchantmentStorageMeta est;
        if (item == null) {
            return false;
        }
        Material itemType = item.getType();
        if (this.plugin.dataConfiguration().blockedMaterials.contains(itemType)) {
            return true;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return false;
        }
        if (itemMeta instanceof EnchantmentStorageMeta && this.checkEnchant((est = (EnchantmentStorageMeta)itemMeta).getStoredEnchants())) {
            return true;
        }
        if (this.checkEnchant(itemMeta.getEnchants())) {
            return true;
        }
        return itemMeta instanceof PotionMeta && this.checkPotion((pm = (PotionMeta)itemMeta).getBasePotionType().getPotionEffects());
    }

    private boolean checkEnchant(Map<Enchantment, Integer> enchants) {
        for (Map.Entry<Enchantment, Integer> enchant : enchants.entrySet()) {
            if (!this.plugin.dataConfiguration().blockedEnchants.containsKey(enchant.getKey()) || this.plugin.dataConfiguration().blockedEnchants.get(enchant.getKey()) > enchant.getValue()) continue;
            return true;
        }
        return false;
    }

    private boolean checkPotion(List<PotionEffect> potions) {
        if (potions == null || potions.isEmpty()) {
            return false;
        }
        for (PotionEffect potion : potions) {
            if (!this.plugin.dataConfiguration().blockedPotions.containsKey(potion.getType()) || this.plugin.dataConfiguration().blockedPotions.get(potion.getType()) - 1 > potion.getAmplifier()) continue;
            return true;
        }
        return false;
    }

    @EventHandler
    public void onSmith(SmithItemEvent event) {
        if (event.getInventory().getResult() != null) {
            Material result = event.getInventory().getResult().getType();
            if (this.plugin.dataConfiguration().netherite && List.of(Material.NETHERITE_AXE, Material.NETHERITE_HOE, Material.NETHERITE_PICKAXE, Material.NETHERITE_SHOVEL, Material.NETHERITE_HELMET, Material.NETHERITE_CHESTPLATE, Material.NETHERITE_LEGGINGS, Material.NETHERITE_BOOTS, Material.NETHERITE_SWORD).contains(result)) {
                event.setResult(Event.Result.DENY);
            }
        }
    }
}

