/*
 * Decompiled with CFR 0.152.
 */
package pl.flezy.itemsblocker.commands;

import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.potion.PotionEffectType;
import pl.flezy.itemsblocker.ItemsBlocker;
import pl.flezy.itemsblocker.libs.acf.BaseCommand;
import pl.flezy.itemsblocker.libs.acf.CommandHelp;
import pl.flezy.itemsblocker.libs.acf.annotation.CommandAlias;
import pl.flezy.itemsblocker.libs.acf.annotation.CommandCompletion;
import pl.flezy.itemsblocker.libs.acf.annotation.CommandPermission;
import pl.flezy.itemsblocker.libs.acf.annotation.Description;
import pl.flezy.itemsblocker.libs.acf.annotation.HelpCommand;
import pl.flezy.itemsblocker.libs.acf.annotation.Optional;
import pl.flezy.itemsblocker.libs.acf.annotation.Subcommand;

@CommandAlias(value="itemsblocker|blocker")
@CommandPermission(value="itemsblocker.command")
public class BlockCommand
extends BaseCommand {
    private final ItemsBlocker plugin = ItemsBlocker.instance();

    @HelpCommand
    public void doHelp(CommandSender sender, CommandHelp help) {
        help.showHelp();
    }

    @Subcommand(value="item add")
    @Description(value="Adds an item to the list of blocked items")
    public void addItem(CommandSender sender, Material material) {
        if (this.plugin.dataConfiguration().blockedMaterials.contains(material)) {
            sender.sendMessage("\u00a7cThis item is already blocked");
            return;
        }
        this.plugin.dataConfiguration().blockedMaterials.add(material);
        this.plugin.dataConfiguration().save();
        sender.sendMessage("\u00a7eItem " + material.toString() + " has been blocked");
    }

    @Subcommand(value="item remove")
    @Description(value="Removes an item from the list of blocked items")
    @CommandCompletion(value="@itemsRemove")
    public void removeItem(CommandSender sender, Material material) {
        if (!this.plugin.dataConfiguration().blockedMaterials.contains(material)) {
            sender.sendMessage("\u00a7cThis item is not blocked");
            return;
        }
        this.plugin.dataConfiguration().blockedMaterials.remove(material);
        this.plugin.dataConfiguration().save();
        sender.sendMessage("\u00a7eItem " + material.toString() + " is no longer blocked");
    }

    @Subcommand(value="item list")
    @Description(value="Displays a list of all blocked items")
    public void listItems(CommandSender sender) {
        if (this.plugin.dataConfiguration().blockedMaterials.isEmpty()) {
            sender.sendMessage("\u00a7cNo blocked items");
            return;
        }
        sender.sendMessage("\u00a7eBlocked items:");
        this.plugin.dataConfiguration().blockedMaterials.forEach(mat -> sender.sendMessage("\u00a78-\u00a77 " + mat.name()));
    }

    @Subcommand(value="enchantment add")
    @Description(value="Adds an enchantment to the list of blocked enchantments, optionally with a level")
    @CommandCompletion(value="@enchantments [level]")
    public void addEnchant(CommandSender sender, String enchantName, @Optional Integer level) {
        Enchantment enchant = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)enchantName));
        if (enchant == null) {
            sender.sendMessage("\u00a7cThis enchantment does not exist");
            return;
        }
        if (level == null) {
            level = 1;
        }
        this.plugin.dataConfiguration().blockedEnchants.put(enchant, level);
        this.plugin.dataConfiguration().save();
        sender.sendMessage("\u00a7eEnchantment " + String.valueOf(enchant.getKey()) + " has been blocked from level " + level);
    }

    @Subcommand(value="enchantment remove")
    @Description(value="Removes enchantments from the list of blocked enchantments")
    @CommandCompletion(value="@enchantmentsRemove")
    public void removeEnchant(CommandSender sender, String enchantName) {
        Enchantment enchant = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)enchantName));
        if (enchant == null) {
            sender.sendMessage("\u00a7cThis enchantment does not exist");
            return;
        }
        if (!this.plugin.dataConfiguration().blockedEnchants.containsKey(enchant)) {
            sender.sendMessage("\u00a7cThis enchantment is not blocked");
            return;
        }
        this.plugin.dataConfiguration().blockedEnchants.remove(enchant);
        this.plugin.dataConfiguration().save();
        sender.sendMessage("\u00a7eEnchantment " + String.valueOf(enchant.getKey()) + " is no longer blocked");
    }

    @Subcommand(value="enchantment list")
    @Description(value="Shows all blocked enchantments with levels")
    public void onListEnchants(CommandSender sender) {
        if (this.plugin.dataConfiguration().blockedEnchants.isEmpty()) {
            sender.sendMessage("\u00a7cNo blocked enchantments");
            return;
        }
        sender.sendMessage("\u00a7eBlocked enchantments:");
        this.plugin.dataConfiguration().blockedEnchants.forEach((key, value) -> {
            String enchantName = key.getKey().getKey();
            int level = value;
            sender.sendMessage("\u00a78-\u00a77 " + enchantName + "  " + level);
        });
    }

    @Subcommand(value="potion add")
    @Description(value="Adds a potion effect to the list of blocked effects")
    @CommandCompletion(value="@potionEffects [level]")
    public void addPotion(CommandSender sender, String potionName, @Optional Integer level) {
        PotionEffectType potion = PotionEffectType.getByKey((NamespacedKey)NamespacedKey.minecraft((String)potionName));
        if (potion == null) {
            sender.sendMessage("\u00a7cThis potion effect does not exist");
            return;
        }
        if (level == null) {
            level = 1;
        }
        this.plugin.dataConfiguration().blockedPotions.put(potion, level);
        this.plugin.dataConfiguration().save();
        sender.sendMessage("\u00a7ePotion effect " + String.valueOf(potion.getKey()) + " has been blocked from level " + level);
    }

    @Subcommand(value="potion remove")
    @Description(value="Removes a potion effect from the list of blocked effects")
    @CommandCompletion(value="@potionEffectsRemove")
    public void removePotion(CommandSender sender, String potionName) {
        PotionEffectType potion = PotionEffectType.getByKey((NamespacedKey)NamespacedKey.minecraft((String)potionName));
        if (potion == null) {
            sender.sendMessage("\u00a7cThis potion effect does not exist");
            return;
        }
        if (!this.plugin.dataConfiguration().blockedPotions.containsKey(potion)) {
            sender.sendMessage("\u00a7cThis potion effect is not blocked");
            return;
        }
        this.plugin.dataConfiguration().blockedPotions.remove(potion);
        this.plugin.dataConfiguration().save();
        sender.sendMessage("\u00a7ePotion effect " + String.valueOf(potion.getKey()) + " is no longer blocked");
    }

    @Subcommand(value="potion list")
    @Description(value="Shows all blocked potion effects")
    public void listPotions(CommandSender sender) {
        if (this.plugin.dataConfiguration().blockedPotions.isEmpty()) {
            sender.sendMessage("\u00a7cNo blocked potion effects");
            return;
        }
        sender.sendMessage("\u00a7eBlocked potions effects:");
        this.plugin.dataConfiguration().blockedPotions.forEach((key, value) -> {
            String potionName = key.getKey().getKey();
            int level = value;
            sender.sendMessage("\u00a78-\u00a77 " + potionName + "  " + level);
        });
    }

    @Subcommand(value="netherite")
    @Description(value="Blocks smithing of netherite items")
    @CommandCompletion(value="true|false")
    public void netherite(CommandSender sender, boolean bool) {
        this.plugin.dataConfiguration().netherite = bool;
        this.plugin.dataConfiguration().save();
        sender.sendMessage("\u00a7eBlocking of netherite item smithing has been set to " + bool);
    }
}

