/*
 * Decompiled with CFR 0.152.
 */
package pl.flezy.itemsblocker.config;

import java.io.File;
import pl.flezy.itemsblocker.ItemsBlocker;
import pl.flezy.itemsblocker.config.DataConfiguration;
import pl.flezy.itemsblocker.libs.eu.okaeri.configs.ConfigManager;
import pl.flezy.itemsblocker.libs.eu.okaeri.configs.serdes.commons.SerdesCommons;
import pl.flezy.itemsblocker.libs.eu.okaeri.configs.validator.okaeri.OkaeriValidator;
import pl.flezy.itemsblocker.libs.eu.okaeri.configs.yaml.bukkit.YamlBukkitConfigurer;
import pl.flezy.itemsblocker.libs.eu.okaeri.configs.yaml.bukkit.serdes.SerdesBukkit;

public class ConfigurationFactory {
    private ConfigurationFactory() {
    }

    public static DataConfiguration createDataConfiguration(File dataConfigurationFile) {
        return ConfigManager.create(DataConfiguration.class, it -> {
            it.withConfigurer(new OkaeriValidator(new YamlBukkitConfigurer()));
            it.withSerdesPack(registry -> {
                registry.register(new SerdesCommons());
                registry.register(new SerdesBukkit());
            });
            it.withBindFile(dataConfigurationFile);
            it.withLogger(ItemsBlocker.instance().getLogger());
            it.saveDefaults();
            it.load(true);
        });
    }
}

