/*
 * Decompiled with CFR 0.152.
 */
package pl.flezy.itemsblocker.libs.eu.okaeri.configs.yaml.bukkit.serdes.serializer.experimental;

import java.util.LinkedHashMap;
import java.util.Map;
import lombok.NonNull;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.yaml.snakeyaml.Yaml;
import pl.flezy.itemsblocker.libs.eu.okaeri.configs.schema.GenericsDeclaration;
import pl.flezy.itemsblocker.libs.eu.okaeri.configs.serdes.DeserializationData;
import pl.flezy.itemsblocker.libs.eu.okaeri.configs.serdes.ObjectSerializer;
import pl.flezy.itemsblocker.libs.eu.okaeri.configs.serdes.SerializationData;

public class CraftItemStackSerializer
implements ObjectSerializer<ItemStack> {
    private static final Yaml YAML = new Yaml();

    @Override
    public boolean supports(@NonNull Class<? super ItemStack> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return ItemStack.class.isAssignableFrom(type);
    }

    @Override
    public void serialize(@NonNull ItemStack stack, @NonNull SerializationData data, @NonNull GenericsDeclaration generics) {
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        YamlConfiguration craftConfig = new YamlConfiguration();
        craftConfig.set("_", (Object)stack);
        Map root = (Map)YAML.load(craftConfig.saveToString());
        Map itemMap = (Map)root.get("_");
        itemMap.remove("==");
        itemMap.forEach(data::add);
    }

    @Override
    public ItemStack deserialize(@NonNull DeserializationData data, @NonNull GenericsDeclaration generics) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        LinkedHashMap<String, Object> itemMap = new LinkedHashMap<String, Object>();
        itemMap.put("==", "org.bukkit.inventory.ItemStack");
        itemMap.putAll(data.asMap());
        YamlConfiguration craftConfig = new YamlConfiguration();
        craftConfig.set("_", itemMap);
        craftConfig.loadFromString(craftConfig.saveToString());
        return craftConfig.getItemStack("_");
    }
}

