/*
 * Decompiled with CFR 0.152.
 */
package pl.flezy.itemsblocker.libs.eu.okaeri.placeholders.message.part;

import java.math.BigDecimal;
import java.util.Arrays;
import lombok.NonNull;

public class FieldParams {
    private final String field;
    private final String[] params;

    public static FieldParams of(String field, @NonNull String[] params) {
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        return new FieldParams(field, params);
    }

    public static FieldParams empty(String field) {
        return new FieldParams(field, new String[0]);
    }

    public int length() {
        return this.params.length;
    }

    public String[] strArr() {
        return this.params;
    }

    public int[] intArr() {
        int[] arr = new int[this.params.length];
        for (int i = 0; i < this.params.length; ++i) {
            arr[i] = this.intAt(i, 0);
        }
        return arr;
    }

    public double[] doubleArr() {
        double[] arr = new double[this.params.length];
        for (int i = 0; i < this.params.length; ++i) {
            arr[i] = this.doubleAt(i, 0.0);
        }
        return arr;
    }

    public String strAt(int pos) {
        return this.strAt(pos, "");
    }

    public String strAt(int pos, String def) {
        if (pos >= this.params.length) {
            return def;
        }
        return this.params[pos];
    }

    public double doubleAt(int pos) {
        return this.doubleAt(pos, 0.0);
    }

    public double doubleAt(int pos, double def) {
        String str = this.strAt(pos, String.valueOf(def));
        try {
            return new BigDecimal(str).doubleValue();
        }
        catch (NumberFormatException exception) {
            return def;
        }
    }

    public int intAt(int pos) {
        return this.intAt(pos, 0);
    }

    public int intAt(int pos, int def) {
        String str = this.strAt(pos, String.valueOf(def));
        try {
            return new BigDecimal(str).intValue();
        }
        catch (NumberFormatException exception) {
            return def;
        }
    }

    public String getField() {
        return this.field;
    }

    public String[] getParams() {
        return this.params;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FieldParams)) {
            return false;
        }
        FieldParams other = (FieldParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        return Arrays.deepEquals(this.getParams(), other.getParams());
    }

    protected boolean canEqual(Object other) {
        return other instanceof FieldParams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getParams());
        return result;
    }

    public String toString() {
        return "FieldParams(field=" + this.getField() + ", params=" + Arrays.deepToString(this.getParams()) + ")";
    }

    private FieldParams(String field, String[] params) {
        this.field = field;
        this.params = params;
    }
}

