/*
 * Decompiled with CFR 0.152.
 */
package pl.flezy.itemsblocker.libs.eu.okaeri.placeholders.message.part;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import pl.flezy.itemsblocker.libs.eu.okaeri.placeholders.message.part.FieldParams;
import pl.flezy.itemsblocker.libs.eu.okaeri.placeholders.message.part.MessageElement;
import pl.flezy.itemsblocker.libs.eu.okaeri.placeholders.message.part.MessageFieldAccessor;
import pl.flezy.itemsblocker.libs.eu.okaeri.placeholders.message.part.MessageFieldTokenizer;

public class MessageField
implements MessageElement,
MessageFieldAccessor {
    private static final MessageFieldTokenizer TOKENIZER = new MessageFieldTokenizer();
    private final Locale locale;
    private final String name;
    private final String source;
    @Nullable
    private final MessageField sub;
    @Nullable
    private String defaultValue;
    @Nullable
    private String metadataRaw;
    @Nullable
    private String raw;
    private FieldParams params;
    private String lastSubPath;
    private MessageField lastSub;
    private String[] metadataOptions;

    @Deprecated
    public static MessageField unknown() {
        return MessageField.of("unknown");
    }

    public static MessageField of(@NonNull String source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return MessageField.of(Locale.ENGLISH, source);
    }

    public static MessageField of(@NonNull Locale locale, @NonNull String source) {
        if (locale == null) {
            throw new NullPointerException("locale is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        List<FieldParams> parts = TOKENIZER.tokenize(source);
        MessageField field = null;
        for (int i = parts.size() - 1; i >= 0; --i) {
            FieldParams pathElement = parts.get(i);
            field = new MessageField(locale, pathElement.getField(), source, field);
            field.setParams(pathElement);
        }
        if (field != null) {
            MessageField lastSub = field.getLastSub();
            String lastSubPath = field.getLastSubPath();
            FieldParams fieldParams = field.getParams();
        }
        return field;
    }

    private static String lastSubPath(@NonNull MessageField field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        MessageField last = field;
        StringBuilder out = new StringBuilder(field.getName());
        while (last.getSub() != null) {
            last = last.getSub();
            out.append(".").append(last.getName());
        }
        return out.toString();
    }

    public void setDefaultValue(@Nullable String defaultValue) {
        this.defaultValue = defaultValue;
        MessageField field = this;
        while (field.getSub() != null) {
            MessageField sub = field.getSub();
            sub.setDefaultValue(defaultValue);
            field = sub;
        }
    }

    public boolean hasSub() {
        return this.sub != null;
    }

    @Nullable
    public MessageField getLastSub() {
        if (this.sub == null) {
            return null;
        }
        if (this.lastSub == null) {
            MessageField last = this.sub;
            while (last.getSub() != null) {
                last = last.getSub();
            }
            this.lastSub = last;
        }
        return this.lastSub;
    }

    public String getLastSubPath() {
        if (this.lastSubPath == null) {
            this.lastSubPath = MessageField.lastSubPath(this);
        }
        return this.lastSubPath;
    }

    public void setMetadataRaw(@Nullable String metadataRaw) {
        this.metadataRaw = metadataRaw;
        MessageField field = this;
        while (field.getSub() != null) {
            MessageField sub = field.getSub();
            sub.setMetadataRaw(metadataRaw);
            sub.updateMetadataOptionsCache();
            field = sub;
        }
        this.updateMetadataOptionsCache();
    }

    public void updateMetadataOptionsCache() {
        if (this.metadataRaw == null) {
            return;
        }
        this.metadataOptions = TOKENIZER.tokenizeArgs(this.metadataRaw).toArray(new String[0]);
    }

    @Override
    public Locale locale() {
        return this.getLocale();
    }

    @Override
    public FieldParams params() {
        return this.getParams();
    }

    @Override
    public MessageField unsafe() {
        return this;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getName() {
        return this.name;
    }

    public String getSource() {
        return this.source;
    }

    @Nullable
    public MessageField getSub() {
        return this.sub;
    }

    @Nullable
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Nullable
    public String getMetadataRaw() {
        return this.metadataRaw;
    }

    @Nullable
    public String getRaw() {
        return this.raw;
    }

    public String[] getMetadataOptions() {
        return this.metadataOptions;
    }

    public void setRaw(@Nullable String raw) {
        this.raw = raw;
    }

    public void setParams(FieldParams params) {
        this.params = params;
    }

    public void setLastSubPath(String lastSubPath) {
        this.lastSubPath = lastSubPath;
    }

    public void setLastSub(MessageField lastSub) {
        this.lastSub = lastSub;
    }

    public void setMetadataOptions(String[] metadataOptions) {
        this.metadataOptions = metadataOptions;
    }

    public String toString() {
        return "MessageField(locale=" + this.getLocale() + ", name=" + this.getName() + ", source=" + this.getSource() + ", sub=" + this.getSub() + ", defaultValue=" + this.getDefaultValue() + ", metadataRaw=" + this.getMetadataRaw() + ", raw=" + this.getRaw() + ", params=" + this.getParams() + ", lastSubPath=" + this.getLastSubPath() + ", lastSub=" + this.getLastSub() + ", metadataOptions=" + Arrays.deepToString(this.getMetadataOptions()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageField)) {
            return false;
        }
        MessageField other = (MessageField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Locale this$locale = this.getLocale();
        Locale other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !((Object)this$locale).equals(other$locale)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        MessageField this$sub = this.getSub();
        MessageField other$sub = other.getSub();
        if (this$sub == null ? other$sub != null : !((Object)this$sub).equals(other$sub)) {
            return false;
        }
        String this$defaultValue = this.getDefaultValue();
        String other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        String this$metadataRaw = this.getMetadataRaw();
        String other$metadataRaw = other.getMetadataRaw();
        if (this$metadataRaw == null ? other$metadataRaw != null : !this$metadataRaw.equals(other$metadataRaw)) {
            return false;
        }
        FieldParams this$params = this.getParams();
        FieldParams other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        String this$lastSubPath = this.getLastSubPath();
        String other$lastSubPath = other.getLastSubPath();
        if (this$lastSubPath == null ? other$lastSubPath != null : !this$lastSubPath.equals(other$lastSubPath)) {
            return false;
        }
        MessageField this$lastSub = this.getLastSub();
        MessageField other$lastSub = other.getLastSub();
        if (this$lastSub == null ? other$lastSub != null : !((Object)this$lastSub).equals(other$lastSub)) {
            return false;
        }
        return Arrays.deepEquals(this.getMetadataOptions(), other.getMetadataOptions());
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageField;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Locale $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : ((Object)$locale).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        MessageField $sub = this.getSub();
        result = result * 59 + ($sub == null ? 43 : ((Object)$sub).hashCode());
        String $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        String $metadataRaw = this.getMetadataRaw();
        result = result * 59 + ($metadataRaw == null ? 43 : $metadataRaw.hashCode());
        FieldParams $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        String $lastSubPath = this.getLastSubPath();
        result = result * 59 + ($lastSubPath == null ? 43 : $lastSubPath.hashCode());
        MessageField $lastSub = this.getLastSub();
        result = result * 59 + ($lastSub == null ? 43 : ((Object)$lastSub).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getMetadataOptions());
        return result;
    }

    private MessageField(Locale locale, String name, String source, @Nullable MessageField sub) {
        this.locale = locale;
        this.name = name;
        this.source = source;
        this.sub = sub;
    }

    public FieldParams getParams() {
        return this.params;
    }
}

