/*
 * Decompiled with CFR 0.152.
 */
package pl.flezy.itemsblocker.libs.eu.okaeri.validator.provider;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.ConstraintViolation;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.annotation.NotNull;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.annotation.Nullable;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.annotation.Pattern;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.exception.ValidatorException;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.provider.ValidationProvider;

public class PatternProvider
implements ValidationProvider<Pattern> {
    @Override
    public Class<Pattern> getAnnotation() {
        return Pattern.class;
    }

    @Override
    public Set<ConstraintViolation> validate(@NotNull Pattern annotation, @Nullable Object annotationSource, @Nullable Object value, @NotNull Class<?> type, @NotNull Type genericType, @NotNull String name) {
        if ((value = this.extractValue(value, type = this.extractType(type, genericType), genericType)) == null) {
            return Collections.emptySet();
        }
        CharSequence objectValue = null;
        if (CharSequence.class.isAssignableFrom(type)) {
            objectValue = (CharSequence)value;
        } else if (annotation.useToString()) {
            objectValue = String.valueOf(value);
        }
        if (objectValue == null) {
            throw new ValidatorException("@Pattern is not applicable for " + type + " (to validate #toString() output set useToString=true) [" + name + "]");
        }
        String patternStr = annotation.value();
        java.util.regex.Pattern pattern = java.util.regex.Pattern.compile(patternStr);
        if (pattern.matcher(objectValue).matches()) {
            return Collections.emptySet();
        }
        String message = annotation.message().replace("{value}", patternStr);
        LinkedHashSet<ConstraintViolation> violations = new LinkedHashSet<ConstraintViolation>();
        violations.add(new ConstraintViolation(name, message, this.getType()));
        return violations;
    }
}

