/*
 * Decompiled with CFR 0.152.
 */
package pl.flezy.itemsblocker.libs.eu.okaeri.validator.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.ConstraintViolation;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.annotation.NotNull;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.annotation.Nullable;
import pl.flezy.itemsblocker.libs.eu.okaeri.validator.exception.ValidatorException;

public interface ValidationProvider<T extends Annotation> {
    public Class<T> getAnnotation();

    default public String getType() {
        return this.getAnnotation().getSimpleName();
    }

    default public boolean shouldValidate(@Nullable Object target) {
        return this.extractAnnotation(target, this.getAnnotation()) != null;
    }

    public Set<ConstraintViolation> validate(@NotNull T var1, @Nullable Object var2, @Nullable Object var3, @NotNull Class<?> var4, @NotNull Type var5, @NotNull String var6);

    default public Set<ConstraintViolation> validate(@NotNull Field field, @Nullable Object value) {
        T annotation = field.getAnnotation(this.getAnnotation());
        return annotation == null ? Collections.emptySet() : this.validate(annotation, field, value, field.getType(), field.getGenericType(), field.getName());
    }

    default public Set<ConstraintViolation> validate(@NotNull Parameter parameter, @Nullable Object value) {
        T annotation = parameter.getAnnotation(this.getAnnotation());
        return annotation == null ? Collections.emptySet() : this.validate(annotation, parameter, value, parameter.getType(), parameter.getParameterizedType(), parameter.getName());
    }

    default public BigDecimal toBigDecimal(@Nullable Object value, @NotNull Class<?> type, @NotNull Type genericType) {
        ParameterizedType parameterizedType;
        Type rawType;
        if (value == null) {
            return null;
        }
        if (Optional.class.isAssignableFrom(type) && genericType instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)genericType).getRawType()) instanceof Class) {
            type = (Class)rawType;
            value = ((Optional)value).get();
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return new BigDecimal(String.valueOf(value));
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return (BigDecimal)value;
        }
        if (BigInteger.class.isAssignableFrom(type)) {
            return new BigDecimal((BigInteger)value);
        }
        if (type == Byte.TYPE || type == Short.TYPE || type == Integer.TYPE || type == Long.TYPE || type == Double.TYPE || type == Float.TYPE) {
            return new BigDecimal(String.valueOf(value));
        }
        if (Number.class.isAssignableFrom(type)) {
            return BigDecimal.valueOf(((Number)value).longValue());
        }
        if (Duration.class.isAssignableFrom(type)) {
            return BigDecimal.valueOf(((Duration)value).toNanos());
        }
        return null;
    }

    default public boolean isNullOrEmpty(@Nullable Object value, @NotNull Class<?> type, @NotNull Type genericType) {
        return this.extractValue(value, type, genericType) == null;
    }

    default public Object extractValue(@Nullable Object value, @NotNull Class<?> type, @NotNull Type genericType) {
        if (value == null) {
            return null;
        }
        if (Optional.class.isAssignableFrom(type)) {
            return ((Optional)value).get();
        }
        return value;
    }

    default public Class<?> extractType(@NotNull Class<?> type, @NotNull Type genericType) {
        ParameterizedType parameterizedType;
        Type rawType;
        if (genericType instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)genericType).getRawType()) instanceof Class) {
            return (Class)rawType;
        }
        return type;
    }

    default public <A extends Annotation> A extractAnnotation(@Nullable Object annotationSource, @NotNull Class<A> type) {
        if (annotationSource instanceof Field) {
            return ((Field)annotationSource).getAnnotation(type);
        }
        if (annotationSource instanceof Parameter) {
            return ((Parameter)annotationSource).getAnnotation(type);
        }
        throw new ValidatorException("Unknown annotation source: " + annotationSource);
    }

    default public Set<ConstraintViolation> compareBigDecimal(@Nullable Object value, @NotNull String name, @NotNull Class<?> type, @NotNull Type genericType, @NotNull Object annotationValue, @NotNull String annotationMessage, @NotNull Predicate<Integer> predicate) {
        if (this.isNullOrEmpty(value, type, genericType)) {
            return Collections.emptySet();
        }
        BigDecimal objectValue = this.toBigDecimal(value, type, genericType);
        if (objectValue == null) {
            throw new ValidatorException("@DecimalMin is not applicable for " + type + " [" + name + "]");
        }
        BigDecimal decimal = this.toBigDecimal(annotationValue, annotationValue.getClass(), null);
        if (decimal == null) {
            throw new ValidatorException("@" + this.getClass().getSimpleName() + " value '" + annotationValue + "' is invalid [" + name + "]");
        }
        if (predicate.test(objectValue.compareTo(decimal))) {
            return Collections.emptySet();
        }
        String message = annotationMessage.replace("{value}", String.valueOf(decimal));
        LinkedHashSet<ConstraintViolation> violations = new LinkedHashSet<ConstraintViolation>();
        violations.add(new ConstraintViolation(name, message, this.getType()));
        return violations;
    }
}

