/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sinfall.init;

import java.util.Map;
import net.mcreator.sinfall.init.SinfallModScreens;
import net.mcreator.sinfall.network.MenuStateUpdateMessage;
import net.mcreator.sinfall.world.inventory.ConfirmHolyGraceGUIMenu;
import net.mcreator.sinfall.world.inventory.ConfirmSinsGUIMenu;
import net.mcreator.sinfall.world.inventory.SelectSinGUIMenu;
import net.mcreator.sinfall.world.inventory.SkillTreeMainMenu;
import net.mcreator.sinfall.world.inventory.SkillTreeSlothMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class SinfallModMenus {
    public static final DeferredRegister<MenuType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"sinfall");
    public static final DeferredHolder<MenuType<?>, MenuType<SelectSinGUIMenu>> SELECT_SIN_GUI = REGISTRY.register("select_sin_gui", () -> IMenuTypeExtension.create(SelectSinGUIMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<SkillTreeMainMenu>> SKILL_TREE_MAIN = REGISTRY.register("skill_tree_main", () -> IMenuTypeExtension.create(SkillTreeMainMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<SkillTreeSlothMenu>> SKILL_TREE_SLOTH = REGISTRY.register("skill_tree_sloth", () -> IMenuTypeExtension.create(SkillTreeSlothMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<ConfirmHolyGraceGUIMenu>> CONFIRM_HOLY_GRACE_GUI = REGISTRY.register("confirm_holy_grace_gui", () -> IMenuTypeExtension.create(ConfirmHolyGraceGUIMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<ConfirmSinsGUIMenu>> CONFIRM_SINS_GUI = REGISTRY.register("confirm_sins_gui", () -> IMenuTypeExtension.create(ConfirmSinsGUIMenu::new));

    public static interface MenuAccessor {
        public Map<String, Object> getMenuState();

        public Map<Integer, Slot> getSlots();

        default public void sendMenuStateUpdate(Player player, int elementType, String name, Object elementState, boolean needClientUpdate) {
            this.getMenuState().put(elementType + ":" + name, elementState);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new MenuStateUpdateMessage(elementType, name, elementState), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (player.level().isClientSide) {
                Screen screen = Minecraft.getInstance().screen;
                if (screen instanceof SinfallModScreens.ScreenAccessor) {
                    SinfallModScreens.ScreenAccessor accessor = (SinfallModScreens.ScreenAccessor)screen;
                    if (needClientUpdate) {
                        accessor.updateMenuState(elementType, name, elementState);
                    }
                }
                ClientPacketDistributor.sendToServer((CustomPacketPayload)new MenuStateUpdateMessage(elementType, name, elementState), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        default public <T> T getMenuState(int elementType, String name, T defaultValue) {
            try {
                return (T)this.getMenuState().getOrDefault(elementType + ":" + name, defaultValue);
            }
            catch (ClassCastException e) {
                return defaultValue;
            }
        }
    }
}

