/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sinfall.network;

import java.util.function.Supplier;
import net.mcreator.sinfall.SinfallMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber
public class SinfallModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"sinfall");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        SinfallMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    @SubscribeEvent
    public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayersInDimension((ServerLevel)player2.level(), (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES), player2.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayersInDimension((ServerLevel)player2.level(), (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES), player2.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayersInDimension((ServerLevel)player2.level(), (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES), player2.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerTickUpdateSyncPlayerVariables(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (((PlayerVariables)player2.getData(SinfallModVariables.PLAYER_VARIABLES))._syncDirty) {
                PacketDistributor.sendToPlayersInDimension((ServerLevel)player2.level(), (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES), player2.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ((PlayerVariables)player2.getData(SinfallModVariables.PLAYER_VARIABLES))._syncDirty = false;
            }
        }
    }

    @SubscribeEvent
    public static void clonePlayer(PlayerEvent.Clone event) {
        PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
        PlayerVariables clone = new PlayerVariables();
        clone.Abyss_Curse = original.Abyss_Curse;
        clone.Sloth_Sin = original.Sloth_Sin;
        clone.Sloth_Sin_Points = original.Sloth_Sin_Points;
        clone.Gluttony_Sin = original.Gluttony_Sin;
        clone.Gluttony_Sin_Points = original.Gluttony_Sin_Points;
        clone.Power_Button_Skill = original.Power_Button_Skill;
        clone.Passive_Button_Skill = original.Passive_Button_Skill;
        clone.Ultimate_Button_Skill = original.Ultimate_Button_Skill;
        clone.SinEnergy = original.SinEnergy;
        clone.MaxSinEnergy = original.MaxSinEnergy;
        clone.HolyGrace = original.HolyGrace;
        clone.SinWay = original.SinWay;
        if (!event.isWasDeath()) {
            // empty if block
        }
        event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data, int player) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"sinfall", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            TagValueOutput output = TagValueOutput.createWithoutContext((ProblemReporter)ProblemReporter.DISCARDING);
            message.data.serialize((ValueOutput)output);
            buffer.writeInt(message.player());
            buffer.writeNbt((Tag)output.buildResult());
        }, buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables(), buffer.readInt());
            message.data.deserialize(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)buffer.registryAccess(), (CompoundTag)buffer.readNbt()));
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    Entity player = context.player().level().getEntity(message.player);
                    if (player == null) {
                        return;
                    }
                    TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)context.player().registryAccess());
                    message.data.serialize((ValueOutput)output);
                    ((PlayerVariables)player.getData(PLAYER_VARIABLES)).deserialize(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)context.player().registryAccess(), (CompoundTag)output.buildResult()));
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements ValueIOSerializable {
        boolean _syncDirty = false;
        public boolean Abyss_Curse = false;
        public boolean Sloth_Sin = false;
        public double Sloth_Sin_Points = 0.0;
        public boolean Gluttony_Sin = false;
        public double Gluttony_Sin_Points = 0.0;
        public String Power_Button_Skill = "";
        public String Passive_Button_Skill = "";
        public String Ultimate_Button_Skill = "";
        public double SinEnergy = 0.0;
        public double MaxSinEnergy = 100.0;
        public boolean HolyGrace = false;
        public boolean SinWay = false;

        public void serialize(ValueOutput output) {
            output.putBoolean("Abyss_Curse", this.Abyss_Curse);
            output.putBoolean("Sloth_Sin", this.Sloth_Sin);
            output.putDouble("Sloth_Sin_Points", this.Sloth_Sin_Points);
            output.putBoolean("Gluttony_Sin", this.Gluttony_Sin);
            output.putDouble("Gluttony_Sin_Points", this.Gluttony_Sin_Points);
            output.putString("Power_Button_Skill", this.Power_Button_Skill);
            output.putString("Passive_Button_Skill", this.Passive_Button_Skill);
            output.putString("Ultimate_Button_Skill", this.Ultimate_Button_Skill);
            output.putDouble("SinEnergy", this.SinEnergy);
            output.putDouble("MaxSinEnergy", this.MaxSinEnergy);
            output.putBoolean("HolyGrace", this.HolyGrace);
            output.putBoolean("SinWay", this.SinWay);
        }

        public void deserialize(ValueInput input) {
            this.Abyss_Curse = input.getBooleanOr("Abyss_Curse", false);
            this.Sloth_Sin = input.getBooleanOr("Sloth_Sin", false);
            this.Sloth_Sin_Points = input.getDoubleOr("Sloth_Sin_Points", 0.0);
            this.Gluttony_Sin = input.getBooleanOr("Gluttony_Sin", false);
            this.Gluttony_Sin_Points = input.getDoubleOr("Gluttony_Sin_Points", 0.0);
            this.Power_Button_Skill = input.getStringOr("Power_Button_Skill", "");
            this.Passive_Button_Skill = input.getStringOr("Passive_Button_Skill", "");
            this.Ultimate_Button_Skill = input.getStringOr("Ultimate_Button_Skill", "");
            this.SinEnergy = input.getDoubleOr("SinEnergy", 0.0);
            this.MaxSinEnergy = input.getDoubleOr("MaxSinEnergy", 0.0);
            this.HolyGrace = input.getBooleanOr("HolyGrace", false);
            this.SinWay = input.getBooleanOr("SinWay", false);
        }

        public void markSyncDirty() {
            this._syncDirty = true;
        }
    }
}

