/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sinfall.network;

import net.mcreator.sinfall.SinfallMod;
import net.mcreator.sinfall.procedures.CloseGuiProcedureProcedure;
import net.mcreator.sinfall.procedures.OpenSkillTreeKeyOnKeyPressedProcedure;
import net.mcreator.sinfall.procedures.SelectPassiveAbilitySlothProcedureProcedure;
import net.mcreator.sinfall.procedures.SelectPowerAbilitySlothProcedureProcedure;
import net.mcreator.sinfall.procedures.SelectUltAbilitySlothProcedureProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber
public record SkillTreeSlothButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SkillTreeSlothButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"sinfall", (String)"skill_tree_sloth_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SkillTreeSlothButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new SkillTreeSlothButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<SkillTreeSlothButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(SkillTreeSlothButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> SkillTreeSlothButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            CloseGuiProcedureProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            OpenSkillTreeKeyOnKeyPressedProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            SelectPowerAbilitySlothProcedureProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            SelectPassiveAbilitySlothProcedureProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            SelectUltAbilitySlothProcedureProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            SelectPowerAbilitySlothProcedureProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            SelectPassiveAbilitySlothProcedureProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            SelectUltAbilitySlothProcedureProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SinfallMod.addNetworkMessage(TYPE, STREAM_CODEC, SkillTreeSlothButtonMessage::handleData);
    }
}

