/*
 * Decompiled with CFR 0.152.
 */
package ga.ozli.minecraftmods.variablespawnerhardness;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import ga.ozli.minecraftmods.variablespawnerhardness.VariableSpawnerHardness;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public record Config(float peaceful, float easy, float normal, float hard, float hardcore) {
    public static final Config DEFAULT;
    public static Config instance;
    private static final Path PATH;

    public float[] hardnessByDifficulty() {
        return new float[]{this.peaceful, this.easy, this.normal, this.hard, this.hardcore};
    }

    static void load() {
        if (!Files.exists(PATH, new LinkOption[0])) {
            VariableSpawnerHardness.LOGGER.warn("No config found, using default");
            Config.writeDefault();
        }
        try {
            instance = (Config)new Gson().fromJson(Files.readString(PATH), Config.class);
        }
        catch (IOException e) {
            VariableSpawnerHardness.LOGGER.fatal("Failed to load config", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static void writeDefault() {
        String defaultConfigJson = new GsonBuilder().setPrettyPrinting().create().toJson((Object)DEFAULT);
        try {
            Files.writeString(PATH, (CharSequence)defaultConfigJson, new OpenOption[0]);
        }
        catch (IOException e) {
            VariableSpawnerHardness.LOGGER.fatal("Failed to write default config", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    static {
        instance = DEFAULT = new Config(5.0f, 9.0f, 22.5f, 30.0f, 50.0f);
        PATH = FabricLoader.getInstance().getConfigDir().resolve("variablespawnerhardness.json");
    }
}

