/*
 * Decompiled with CFR 0.152.
 */
package ga.ozli.minecraftmods.variablespawnerhardness;

import net.minecraftforge.common.ForgeConfigSpec;

final class Config {
    static final ForgeConfigSpec CONFIG_SPEC;
    private static final ForgeConfigSpec.FloatValue peaceful;
    private static final ForgeConfigSpec.FloatValue easy;
    private static final ForgeConfigSpec.FloatValue medium;
    private static final ForgeConfigSpec.FloatValue hard;
    private static final ForgeConfigSpec.FloatValue hardcore;

    private Config() {
    }

    static float getPeaceful() {
        return LazyInit.PEACEFUL;
    }

    static float getHardness(int difficulty) {
        return switch (difficulty) {
            case 0 -> LazyInit.PEACEFUL;
            case 1 -> LazyInit.EASY;
            case 2 -> LazyInit.MEDIUM;
            case 3 -> LazyInit.HARD;
            case 4 -> LazyInit.HARDCORE;
            default -> throw new UnsupportedOperationException("Unknown difficulty: " + difficulty);
        };
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("Hardnesses");
        peaceful = builder.defineInRange("Peaceful", 5.0f, 5.0f, 50.0f);
        easy = builder.defineInRange("Easy", 9.0f, 5.0f, 50.0f);
        medium = builder.defineInRange("Medium", 22.5f, 5.0f, 50.0f);
        hard = builder.defineInRange("Hard", 30.0f, 5.0f, 50.0f);
        hardcore = builder.defineInRange("Hardcore", 50.0f, 5.0f, 50.0f);
        builder.pop();
        CONFIG_SPEC = builder.build();
    }

    private static final class LazyInit {
        private static final float PEACEFUL = ((Float)peaceful.get()).floatValue();
        private static final float EASY = ((Float)easy.get()).floatValue();
        private static final float MEDIUM = ((Float)medium.get()).floatValue();
        private static final float HARD = ((Float)hard.get()).floatValue();
        private static final float HARDCORE = ((Float)hardcore.get()).floatValue();

        private LazyInit() {
        }
    }
}

