/*
 * Decompiled with CFR 0.152.
 */
package ga.ozli.minecraftmods.variablespawnerhardness;

import ga.ozli.minecraftmods.variablespawnerhardness.Config;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.storage.LevelData;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.LoggerFactory;

@Mod(value="variablespawnerhardness")
public final class VariableSpawnerHardness {
    public VariableSpawnerHardness(FMLJavaModLoadingContext context) {
        LoggerFactory.getLogger(VariableSpawnerHardness.class).info("VariableSpawnerHardness starting");
        PlayerEvent.BreakSpeed.BUS.addListener(VariableSpawnerHardness::breakSpeed);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.CONFIG_SPEC);
    }

    private static void breakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.getState().getBlock() instanceof SpawnerBlock) {
            event.setNewSpeed(event.getOriginalSpeed() * (Config.getPeaceful() / Config.getHardness(VariableSpawnerHardness.getDifficulty(event.getEntity().level()))));
        }
    }

    private static int getDifficulty(Level level) {
        LevelData levelData = level.getLevelData();
        return levelData.isHardcore() ? 4 : levelData.getDifficulty().ordinal();
    }
}

