/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.firework.keybinding.service;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class FireworkKeyMappingService {
    private static FireworkKeyMappingService INSTANCE;

    public static FireworkKeyMappingService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FireworkKeyMappingService();
        }
        return INSTANCE;
    }

    public void handleFireworkKeyPressedEvent(Minecraft minecraft) {
        LocalPlayer player = minecraft.player;
        Inventory inventory = Objects.requireNonNull(minecraft.player).getInventory();
        for (int slot = 0; slot < inventory.getContainerSize(); ++slot) {
            ItemStack itemStack = inventory.getItem(slot);
            if (!itemStack.is(Items.FIREWORK_ROCKET)) continue;
            this.useFireworkRocket(slot, player, minecraft);
            break;
        }
    }

    private void useFireworkRocket(int slot, LocalPlayer player, Minecraft minecraft) {
        MultiPlayerGameMode gameMode = minecraft.gameMode;
        if (gameMode == null) {
            return;
        }
        if (player.getMainHandItem().is(Items.FIREWORK_ROCKET)) {
            gameMode.useItem((Player)player, InteractionHand.MAIN_HAND);
        } else if (player.getOffhandItem().is(Items.FIREWORK_ROCKET)) {
            gameMode.useItem((Player)player, InteractionHand.OFF_HAND);
        } else {
            this.swapAndUseFireworkRocket(slot, player, gameMode);
        }
    }

    private void swapAndUseFireworkRocket(int slot, LocalPlayer player, MultiPlayerGameMode gameMode) {
        slot = this.getSlotIndex(slot);
        int selectedSlot = this.getSlotIndex(player.getInventory().getSelectedSlot());
        this.swapFireworkRocket(gameMode, slot, selectedSlot, player);
        gameMode.useItem((Player)player, InteractionHand.MAIN_HAND);
        this.swapFireworkRocket(gameMode, slot, selectedSlot, player);
    }

    private int getSlotIndex(int slot) {
        if (slot <= 8) {
            slot += 36;
        }
        return slot;
    }

    private void swapFireworkRocket(MultiPlayerGameMode gameMode, int slot, int selectedSlot, LocalPlayer player) {
        if (selectedSlot == 36) {
            gameMode.handleInventoryMouseClick(0, selectedSlot, 0, ClickType.SWAP, (Player)player);
            gameMode.handleInventoryMouseClick(0, slot, 0, ClickType.SWAP, (Player)player);
            gameMode.handleInventoryMouseClick(0, selectedSlot, 0, ClickType.SWAP, (Player)player);
        } else {
            gameMode.handleInventoryMouseClick(0, slot, 0, ClickType.SWAP, (Player)player);
            gameMode.handleInventoryMouseClick(0, selectedSlot, 0, ClickType.SWAP, (Player)player);
            gameMode.handleInventoryMouseClick(0, slot, 0, ClickType.SWAP, (Player)player);
        }
    }
}

