/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.thecopperierage.block;

import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.BiConsumer;
import net.frozenblock.thecopperierage.block.entity.ChimeBlockEntity;
import net.frozenblock.thecopperierage.block.state.properties.ChimeAttachType;
import net.frozenblock.thecopperierage.registry.TCABlockEntityTypes;
import net.frozenblock.thecopperierage.registry.TCABlockStateProperties;
import net.frozenblock.thecopperierage.registry.TCASounds;
import net.minecraft.class_10225;
import net.minecraft.class_10774;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChimeBlock
extends class_2237 {
    public static final MapCodec<ChimeBlock> CODEC = ChimeBlock.method_54094(ChimeBlock::new);
    public static final class_2754<class_2350> FACING = class_2383.field_11177;
    public static final class_2754<ChimeAttachType> ATTACHMENT = TCABlockStateProperties.CHIME_ATTACHMENT;
    private static final class_265 SUPPORT_CHAIN_SHAPE = class_2248.method_9541((double)7.0, (double)12.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final class_265 BAR_SHAPE = class_2248.method_9541((double)7.0, (double)10.0, (double)0.0, (double)9.0, (double)12.0, (double)16.0);
    private static final class_265 OUTLINE_SHAPE = class_259.method_1084((class_265)BAR_SHAPE, (class_265)class_2248.method_9541((double)7.0, (double)0.0, (double)1.0, (double)9.0, (double)10.0, (double)15.0));
    private static final Map<class_2350, class_265> CEILING_SHAPES_OUTLINE = class_259.method_66501((class_265)class_259.method_1084((class_265)SUPPORT_CHAIN_SHAPE, (class_265)OUTLINE_SHAPE));
    private static final Map<class_2350, class_265> CEILING_SHAPES_COLLISION = class_259.method_66501((class_265)class_259.method_1084((class_265)SUPPORT_CHAIN_SHAPE, (class_265)BAR_SHAPE));
    private static final Map<class_2350, class_265> WALL_SHAPES_OUTLINE = class_259.method_66501((class_265)OUTLINE_SHAPE);
    private static final Map<class_2350, class_265> WALL_SHAPES_COLLISION = class_259.method_66501((class_265)BAR_SHAPE);
    private static final Map<class_2350, class_265> ENTITY_INSIDE_SHAPES = class_259.method_66501((class_265)class_2248.method_9541((double)6.5, (double)-0.5, (double)-0.5, (double)9.5, (double)10.5, (double)16.5));

    public ChimeBlock(@NotNull class_4970.class_2251 settings) {
        super(settings);
    }

    @NotNull
    protected MapCodec<? extends ChimeBlock> method_53969() {
        return CODEC;
    }

    protected void method_9515(@NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, ATTACHMENT});
    }

    @NotNull
    protected class_265 method_9530(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_3726 collisionContext) {
        return ChimeBlock.getVoxelShape(state, ChimeShapeType.OUTLINE);
    }

    @NotNull
    protected class_265 method_9549(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_3726 collisionContext) {
        return ChimeBlock.getVoxelShape(state, ChimeShapeType.COLLISION);
    }

    @NotNull
    protected class_265 method_64022(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_1297 entity) {
        return ChimeBlock.getVoxelShape(state, ChimeShapeType.ENTITY_INSIDE);
    }

    private static class_265 getVoxelShape(@NotNull class_2680 state, ChimeShapeType shapeType) {
        class_2350 direction = (class_2350)state.method_11654(FACING);
        return switch ((ChimeAttachType)((Object)state.method_11654(ATTACHMENT))) {
            default -> throw new MatchException(null, null);
            case ChimeAttachType.WALL -> ChimeBlock.selectShapeListFromType(shapeType, WALL_SHAPES_OUTLINE, WALL_SHAPES_COLLISION, ENTITY_INSIDE_SHAPES).get(direction);
            case ChimeAttachType.CEILING -> ChimeBlock.selectShapeListFromType(shapeType, CEILING_SHAPES_OUTLINE, CEILING_SHAPES_COLLISION, ENTITY_INSIDE_SHAPES).get(direction);
        };
    }

    @Nullable
    public class_2680 method_9605(@NotNull class_1750 context) {
        class_2350 direction = context.method_8038();
        class_2338 pos = context.method_8037();
        class_1937 level = context.method_8045();
        if (direction == class_2350.field_11036) {
            return null;
        }
        if (direction == class_2350.field_11033) {
            class_2680 state = (class_2680)((class_2680)this.method_9564().method_11657(ATTACHMENT, (Comparable)((Object)ChimeAttachType.CEILING))).method_11657(FACING, (Comparable)context.method_8042().method_10170());
            return state.method_26184((class_4538)level, pos) ? state : null;
        }
        class_2680 state = (class_2680)((class_2680)this.method_9564().method_11657(FACING, (Comparable)direction)).method_11657(ATTACHMENT, (Comparable)((Object)ChimeAttachType.WALL));
        if (state.method_26184((class_4538)level, pos)) {
            return state;
        }
        class_2338 abovePos = pos.method_10074();
        if (!level.method_8320(abovePos).method_26206((class_1922)level, abovePos, class_2350.field_11033)) {
            return null;
        }
        if ((state = (class_2680)state.method_11657(ATTACHMENT, (Comparable)((Object)ChimeAttachType.CEILING))).method_26184((class_4538)level, pos)) {
            return state;
        }
        return null;
    }

    @NotNull
    protected class_2680 method_9559(@NotNull class_2680 state, @NotNull class_4538 level, @NotNull class_10225 scheduledTickAccess, @NotNull class_2338 pos, @NotNull class_2350 direction, @NotNull class_2338 neighborPos, @NotNull class_2680 neighborState, @NotNull class_5819 random) {
        class_2350 connectedDirection = ChimeBlock.getConnectedDirection(state);
        if (connectedDirection.method_10153() == direction && !state.method_26184(level, pos)) {
            return class_2246.field_10124.method_9564();
        }
        return super.method_9559(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    public boolean method_9558(@NotNull class_2680 state, @NotNull class_4538 level, @NotNull class_2338 pos) {
        class_2350 connectedDirection = ChimeBlock.getConnectedDirection(state).method_10153();
        return connectedDirection == class_2350.field_11036 ? class_2248.method_20044((class_4538)level, (class_2338)pos.method_10084(), (class_2350)class_2350.field_11033) : class_2341.method_20046((class_4538)level, (class_2338)pos, (class_2350)connectedDirection);
    }

    private static class_2350 getConnectedDirection(@NotNull class_2680 state) {
        if (state.method_11654(ATTACHMENT) == ChimeAttachType.CEILING) {
            return class_2350.field_11033;
        }
        return (class_2350)state.method_11654(FACING);
    }

    @Nullable
    public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
        return new ChimeBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(@NotNull class_1937 level, @NotNull class_2680 state, @NotNull class_2591<T> blockEntityType) {
        return ChimeBlock.method_31618(blockEntityType, TCABlockEntityTypes.CHIME, ChimeBlockEntity::tick);
    }

    @NotNull
    protected class_1269 method_55766(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1657 player, class_3965 hitResult) {
        class_2586 class_25862 = level.method_8321(pos);
        if (!(class_25862 instanceof ChimeBlockEntity)) {
            return super.method_55766(state, level, pos, player, hitResult);
        }
        ChimeBlockEntity chime = (ChimeBlockEntity)class_25862;
        class_243 playerPos = player.method_33571();
        class_243 barCenter = pos.method_46558().method_61889(0.3125);
        class_243 difference = barCenter.method_1020(playerPos);
        class_243 differenceWithoutY = new class_243(difference.method_10216(), 0.0, difference.method_10215());
        double strength = (barCenter.method_10214() - hitResult.method_17784().method_10214()) * 1.25;
        return chime.addEntityInfluence(level, pos, state, (class_1297)player, differenceWithoutY.method_1029().method_1021(strength), 0.98, true, false) ? class_1269.field_5812 : class_1269.field_21466;
    }

    public void method_9548(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1297 entity, class_10774 insideBlockEffectApplier) {
        class_243 movement = entity.method_18798();
        double length = movement.method_1033();
        if (length == 0.0) {
            return;
        }
        class_2586 class_25862 = level.method_8321(pos);
        if (!(class_25862 instanceof ChimeBlockEntity)) {
            return;
        }
        ChimeBlockEntity chime = (ChimeBlockEntity)class_25862;
        chime.addEntityInfluence(level, pos, state, entity, movement.method_1029().method_1021(Math.min(1.0, length * 2.0)), 0.96, false, true);
    }

    protected void method_55124(@NotNull class_2680 state, @NotNull class_3218 level, @NotNull class_2338 pos, @NotNull class_1927 explosion, BiConsumer<class_1799, class_2338> biConsumer) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof ChimeBlockEntity) {
            ChimeBlockEntity chime = (ChimeBlockEntity)class_25862;
            float radius = explosion.method_55107();
            class_243 difference = pos.method_46558().method_1020(explosion.method_55109());
            double closeness = ((double)radius - difference.method_1033()) / (double)radius;
            chime.addInfluence((class_1937)level, pos, state, difference.method_1029().method_1021(closeness), 0.9875, true, true);
        }
        super.method_55124(state, level, pos, explosion, biConsumer);
    }

    @NotNull
    public class_2680 method_9598(@NotNull class_2680 state, @NotNull class_2470 rotation) {
        return (class_2680)state.method_11657(FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654(FACING)));
    }

    @NotNull
    public class_2680 method_9569(@NotNull class_2680 state, @NotNull class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654(FACING)));
    }

    public void method_9496(class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_5819 random) {
        class_2586 class_25862 = level.method_8321(pos);
        if (!(class_25862 instanceof ChimeBlockEntity)) {
            return;
        }
        ChimeBlockEntity chime = (ChimeBlockEntity)class_25862;
        class_243 influence = chime.getInfluence(1.0f);
        float influenceSpeed = Math.clamp((float)influence.method_1033(), 0.02f, 1.2f);
        if (random.method_43057() >= influenceSpeed * 0.25f) {
            return;
        }
        float volume = class_3532.method_16439((float)influenceSpeed, (float)0.1f, (float)1.0f);
        float pitch = class_3532.method_16439((float)influenceSpeed, (float)0.75f, (float)1.2f);
        level.method_45446(pos, TCASounds.BLOCK_CHIME_AMBIENT, class_3419.field_15256, volume, pitch, false);
    }

    @Contract(pure=true)
    private static Map<class_2350, class_265> selectShapeListFromType(@NotNull ChimeShapeType shapeType, Map<class_2350, class_265> outline, Map<class_2350, class_265> collision, Map<class_2350, class_265> entityInside) {
        return switch (shapeType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> outline;
            case 1 -> collision;
            case 2 -> entityInside;
        };
    }

    public static enum ChimeShapeType {
        OUTLINE,
        COLLISION,
        ENTITY_INSIDE;

    }
}

