/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.thecopperierage.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.frozenblock.lib.particle.options.WindParticleOptions;
import net.frozenblock.lib.wind.api.BlowingHelper;
import net.frozenblock.lib.wind.api.WindDisturbance;
import net.frozenblock.lib.wind.api.WindDisturbanceLogic;
import net.frozenblock.lib.wind.api.WindManager;
import net.frozenblock.lib.wind.client.impl.ClientWindManager;
import net.frozenblock.thecopperierage.entity.impl.CopperFanQueuedMovementInterface;
import net.frozenblock.thecopperierage.mod_compat.FrozenLibIntegration;
import net.frozenblock.thecopperierage.networking.packet.TCACopperFanBlowPacket;
import net.frozenblock.thecopperierage.registry.TCASounds;
import net.frozenblock.thecopperierage.tag.TCAEntityTypeTags;
import net.minecraft.class_10225;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1750;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5575;
import net.minecraft.class_5819;
import net.minecraft.class_5955;
import net.minecraft.class_9904;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopperFanBlock
extends class_2318 {
    public static final double PUSH_INTENSITY = 0.15;
    public static final double PUSH_INTENSITY_SUCK_SCALE = 0.8;
    public static final double PUSH_INTENSITY_SUCK = 0.12;
    public static final double WIND_INTENSITY = 0.5;
    public static final double WIND_INTENSITY_SUCK_SCALE = 0.8;
    public static final double WIND_INTENSITY_SUCK = 0.4;
    private static final WindDisturbanceLogic<? extends CopperFanBlock> DUMMY_WIND_LOGIC = new WindDisturbanceLogic((source, level1, windOrigin, affectedArea, windTarget) -> WindDisturbance.DUMMY_RESULT);
    public static final MapCodec<CopperFanBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5955.class_5811.field_46493.fieldOf("weathering_state").forGetter(copperFanBlock -> copperFanBlock.weatherState), (App)CopperFanBlock.method_54096()).apply((Applicative)instance, CopperFanBlock::new));
    public static final class_2746 POWERED = class_2741.field_12484;
    public final class_5955.class_5811 weatherState;
    public final int pushBlocks;
    public final int suckBlocks;
    private final double cosmeticStrength;
    private final int windParticleLifetime;

    public CopperFanBlock(class_5955.class_5811 weatherState, class_4970.class_2251 properties) {
        super(properties);
        this.weatherState = weatherState;
        this.pushBlocks = CopperFanBlock.getPushForWeatherState(weatherState);
        this.suckBlocks = CopperFanBlock.getSuckForWeatherState(weatherState);
        this.windParticleLifetime = CopperFanBlock.getWindParticleLifetimeForWeatherState(weatherState);
        this.cosmeticStrength = CopperFanBlock.getCosmeticStrengthForWeatherState(weatherState);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)field_10927, (Comparable)class_2350.field_11043)).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Contract(pure=true)
    private static int getPushForWeatherState(@NotNull class_5955.class_5811 weatherState) {
        return switch (weatherState) {
            default -> throw new MatchException(null, null);
            case class_5955.class_5811.field_28704 -> 8;
            case class_5955.class_5811.field_28705 -> 6;
            case class_5955.class_5811.field_28706 -> 4;
            case class_5955.class_5811.field_28707 -> 2;
        };
    }

    @Contract(pure=true)
    private static int getSuckForWeatherState(@NotNull class_5955.class_5811 weatherState) {
        return Math.max(0, CopperFanBlock.getPushForWeatherState(weatherState) - 2);
    }

    @Contract(pure=true)
    private static double getCosmeticStrengthForWeatherState(@NotNull class_5955.class_5811 weatherState) {
        return switch (weatherState) {
            default -> throw new MatchException(null, null);
            case class_5955.class_5811.field_28704 -> 1.0;
            case class_5955.class_5811.field_28705 -> 0.7;
            case class_5955.class_5811.field_28706 -> 0.4;
            case class_5955.class_5811.field_28707 -> 0.2;
        };
    }

    @Contract(pure=true)
    private static int getWindParticleLifetimeForWeatherState(@NotNull class_5955.class_5811 weatherState) {
        return switch (weatherState) {
            default -> throw new MatchException(null, null);
            case class_5955.class_5811.field_28704 -> 12;
            case class_5955.class_5811.field_28705 -> 8;
            case class_5955.class_5811.field_28706 -> 7;
            case class_5955.class_5811.field_28707 -> 7;
        };
    }

    @NotNull
    public MapCodec<? extends CopperFanBlock> method_53969() {
        return CODEC;
    }

    public class_2680 method_9605(@NotNull class_1750 blockPlaceContext) {
        class_2350 facing = blockPlaceContext.method_7715().method_10153();
        return (class_2680)this.method_9564().method_11657((class_2769)field_10927, (Comparable)facing);
    }

    protected void method_9588(@NotNull class_2680 state, @NotNull class_3218 level, @NotNull class_2338 pos, @NotNull class_5819 random) {
        this.updateFan(state, level, pos, random);
    }

    protected void method_9615(@NotNull class_2680 state, @NotNull class_1937 level, class_2338 pos, @NotNull class_2680 replacingState, boolean bl) {
        if (level.method_8608() || state.method_27852(replacingState.method_26204())) {
            return;
        }
        level.method_64310(pos, (class_2248)this, 1);
    }

    protected void method_9612(class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, class_2248 block, @Nullable class_9904 orientation, boolean movedByPiston) {
        if (level.method_8608() || level.method_8397().method_8674(pos, (Object)this)) {
            return;
        }
        level.method_64310(pos, (class_2248)this, 1);
    }

    @NotNull
    protected class_2680 method_9559(@NotNull class_2680 state, @NotNull class_4538 level, @NotNull class_10225 scheduledTickAccess, @NotNull class_2338 pos, @NotNull class_2350 direction, @NotNull class_2338 neighborPos, @NotNull class_2680 neighborState, @NotNull class_5819 random) {
        scheduledTickAccess.method_64310(pos, (class_2248)this, 1);
        return super.method_9559(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    protected boolean method_9579(class_2680 state) {
        return true;
    }

    public void updateFan(@NotNull class_2680 state, @NotNull class_3218 level, class_2338 pos, class_5819 random) {
        boolean hasNeighborSignal = level.method_49803(pos);
        boolean powered = (Boolean)state.method_11654((class_2769)POWERED);
        class_2350 facing = (class_2350)state.method_11654((class_2769)field_10927);
        if (hasNeighborSignal != powered) {
            class_2680 newState = (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(hasNeighborSignal));
            level.method_8652(pos, newState, 3);
            class_3414 toggleSound = hasNeighborSignal ? TCASounds.BLOCK_COPPER_FAN_ON : TCASounds.BLOCK_COPPER_FAN_OFF;
            level.method_8396(null, pos, toggleSound, class_3419.field_15245, class_3532.method_16439((float)((float)this.cosmeticStrength), (float)0.3f, (float)0.9f), class_3532.method_16439((float)((float)this.cosmeticStrength), (float)0.75f, (float)0.9f) + random.method_43057() * 0.2f);
        }
        if (hasNeighborSignal) {
            this.blow((class_1937)level, pos, facing);
            TCACopperFanBlowPacket.sendToAll(level, pos);
            level.method_64310(pos, (class_2248)this, 1);
        }
    }

    public void blow(class_1937 level, @NotNull class_2338 pos, class_2350 facing) {
        this.handleBlowing(level, pos, facing, false);
        this.handleBlowing(level, pos, facing.method_10153(), true);
    }

    @NotNull
    @Contract(value="_, _ -> new")
    private static class_238 aabb(@NotNull class_2338 startPos, @NotNull class_2338 endPos) {
        return new class_238((double)Math.min(startPos.method_10263(), endPos.method_10263()), (double)Math.min(startPos.method_10264(), endPos.method_10264()), (double)Math.min(startPos.method_10260(), endPos.method_10260()), (double)Math.max(startPos.method_10263(), endPos.method_10263()) + 1.0, (double)Math.max(startPos.method_10264(), endPos.method_10264()) + 1.0, (double)Math.max(startPos.method_10260(), endPos.method_10260()) + 1.0);
    }

    private void handleBlowing(class_1937 level, @NotNull class_2338 pos, class_2350 direction, boolean reverse) {
        Optional<class_2338> cutoffPos = Optional.empty();
        class_2338.class_2339 mutablePos = pos.method_25503();
        int fanDistanceInBlocks = !reverse ? this.pushBlocks : this.suckBlocks;
        for (int i = 0; i < fanDistanceInBlocks; ++i) {
            boolean isFirstSearch;
            boolean bl = isFirstSearch = i == 0;
            if (!level.method_22340((class_2338)mutablePos.method_10098(direction))) break;
            class_2680 state = level.method_8320((class_2338)mutablePos);
            if (!BlowingHelper.canBlowingPassThrough((class_4538)level, (class_2338)mutablePos, (class_2680)state, (class_2350)direction)) {
                if (!isFirstSearch) break;
                return;
            }
            if (level.method_8316((class_2338)mutablePos).method_15769()) continue;
            if (isFirstSearch) {
                return;
            }
            cutoffPos = Optional.of(mutablePos.method_10062());
            break;
        }
        class_2350 oppositeDirection = direction.method_10153();
        mutablePos.method_10098(oppositeDirection);
        class_2338 posWithCutoff = cutoffPos.map(blockPos -> blockPos.method_10062().method_10093(oppositeDirection)).orElse(mutablePos.method_10062());
        class_238 blowingArea = CopperFanBlock.aabb(pos, posWithCutoff);
        List entities = level.method_18023(class_5575.method_31795(class_1297.class), blowingArea, class_1301.field_6154.and(class_1301.field_6155));
        class_243 fanStartPos = class_243.method_24953((class_2382)pos);
        WindDisturbance windDisturbance = new WindDisturbance(Optional.of(this), fanStartPos, blowingArea.method_1014(0.5).method_60314(direction.method_23955().mul(0.5f)), WindDisturbanceLogic.getWindDisturbanceLogic((class_2960)(!reverse ? FrozenLibIntegration.COPPER_FAN_WIND_DISTURBANCE : FrozenLibIntegration.COPPER_FAN_WIND_DISTURBANCE_REVERSE)).orElse(DUMMY_WIND_LOGIC));
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            WindManager windManager = WindManager.getOrCreateWindManager((class_3218)serverLevel);
            windManager.addWindDisturbance(windDisturbance);
        } else if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            CopperFanBlock.addWindDisturbanceToClient(windDisturbance);
            class_5819 random = level.method_8409();
            float f = random.method_43057();
            float f2 = !reverse ? 0.35f : 0.2f;
            if (f <= f2 && random.method_43058() <= this.cosmeticStrength) {
                class_243 particleVelocity;
                class_243 particlePos;
                double sizeOfBlowingArea = Math.min(blowingArea.method_995() / 9.0, 1.0);
                if (random.method_43058() < sizeOfBlowingArea * random.method_43058() * random.method_43058()) {
                    level.method_45446(pos.method_10093(direction), TCASounds.BLOCK_COPPER_FAN_IDLE_BLOW, class_3419.field_15245, Math.max((float)sizeOfBlowingArea * 1.2f, 0.6f), Math.max((float)sizeOfBlowingArea, 0.5f), false);
                }
                if (!reverse) {
                    particlePos = CopperFanBlock.getParticlePos(pos, direction, random);
                    particleVelocity = CopperFanBlock.getParticleVelocity(direction, random, 0.4, 0.6);
                    particleVelocity = particleVelocity.method_1019(CopperFanBlock.getVelocityFromDistance(pos, direction, particlePos, random, 0.175));
                } else {
                    class_2338 startPos = pos.method_10093(direction);
                    class_2338 endPos = posWithCutoff.method_10093(direction);
                    class_2338 particleBlockPos = class_2338.method_49638((class_2374)class_3532.method_61342((double)random.method_43058(), (class_243)startPos.method_46558(), (class_243)endPos.method_46558()));
                    particlePos = CopperFanBlock.getParticlePos(particleBlockPos, oppositeDirection, random);
                    particleVelocity = CopperFanBlock.getParticleVelocity(oppositeDirection, random, 0.2, 0.4);
                    particleVelocity = particleVelocity.method_1019(CopperFanBlock.getVelocityFromDistance(pos, oppositeDirection, particlePos, random, 0.1));
                }
                if (particleVelocity.method_1033() > 0.075 && class_2350.method_58251((class_243)particleVelocity) == (!reverse ? direction : oppositeDirection)) {
                    level.method_8494((class_2394)new WindParticleOptions(this.windParticleLifetime, particleVelocity.method_1021(this.cosmeticStrength)), particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 0.0, 0.0, 0.0);
                }
            }
        }
        double fanDistance = (double)fanDistanceInBlocks + 1.0;
        double pushIntensity = !reverse ? 0.15 : 0.12;
        class_243 movement = class_243.method_24954((class_2382)(!reverse ? direction : oppositeDirection).method_62675());
        for (class_1297 entity : entities) {
            class_1665 abstractArrow;
            class_238 boundingBox;
            if (!(entity instanceof CopperFanQueuedMovementInterface)) continue;
            CopperFanQueuedMovementInterface queuedMovementInterface = (CopperFanQueuedMovementInterface)entity;
            if (entity.method_5864().method_20210(TCAEntityTypeTags.COPPER_FAN_CANNOT_PUSH) || !blowingArea.method_994(boundingBox = entity.method_5829())) continue;
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                if (player.method_31549().field_7479) continue;
                if (direction == class_2350.field_11036) {
                    class_243 lastImpactPos = player.field_49989;
                    class_243 playerPos = player.method_73189();
                    player.field_49989 = new class_243(playerPos.method_10216(), lastImpactPos != null ? Math.min(lastImpactPos.method_10214(), playerPos.method_10214()) : playerPos.method_10214(), playerPos.method_10215());
                    player.method_60984(true);
                }
            } else if (entity instanceof class_1665 && (abstractArrow = (class_1665)entity).method_65059()) continue;
            double pushScale = !entity.method_5864().method_20210(TCAEntityTypeTags.COPPER_FAN_WEAKER_PUSH) ? 1.0 : 0.5;
            double intensity = (fanDistance - Math.min(entity.method_73189().method_1022(fanStartPos), fanDistance)) / fanDistance;
            double overallIntensity = intensity * pushIntensity * pushScale;
            class_243 fanMovement = movement.method_1021(overallIntensity);
            queuedMovementInterface.theCopperierAge$queueCopperFanMovement(fanMovement);
            entity.field_6007 = true;
        }
    }

    @NotNull
    public static class_243 getParticleVelocity(@NotNull class_2350 direction, @NotNull class_5819 random, double min, double max) {
        double difference = max - min;
        double velocity = min + random.method_43058() * difference;
        double x = (double)direction.method_10148() * velocity;
        double y = (double)direction.method_10164() * velocity;
        double z = (double)direction.method_10165() * velocity;
        return new class_243(x, y, z);
    }

    @NotNull
    public static class_243 getVelocityFromDistance(class_2338 pos, class_2350 direction, @NotNull class_243 vec3, @NotNull class_5819 random, double max) {
        return vec3.method_1020(CopperFanBlock.getParticlePosWithoutRandom(pos, direction, random)).method_1021(random.method_43058() * max);
    }

    @NotNull
    public static class_243 getParticlePosWithoutRandom(class_2338 pos, class_2350 direction, class_5819 random) {
        return class_243.method_24954((class_2382)pos).method_1031(CopperFanBlock.getParticleOffsetX(direction, random, false), CopperFanBlock.getParticleOffsetY(direction, random, false), CopperFanBlock.getParticleOffsetZ(direction, random, false));
    }

    @NotNull
    public static class_243 getParticlePos(class_2338 pos, class_2350 direction, class_5819 random) {
        return class_243.method_24954((class_2382)pos).method_1031(CopperFanBlock.getParticleOffsetX(direction, random, true), CopperFanBlock.getParticleOffsetY(direction, random, true), CopperFanBlock.getParticleOffsetZ(direction, random, true));
    }

    private static double getRandomParticleOffset(@NotNull class_5819 random) {
        return random.method_43058() / 3.0 * (random.method_43056() ? 1.0 : -1.0);
    }

    private static double getParticleOffsetX(@NotNull class_2350 direction, class_5819 random, boolean useRandom) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11036, class_2350.field_11033, class_2350.field_11035, class_2350.field_11043 -> 0.5 + (useRandom ? CopperFanBlock.getRandomParticleOffset(random) : 0.0);
            case class_2350.field_11034 -> 1.05;
            case class_2350.field_11039 -> -0.05;
        };
    }

    private static double getParticleOffsetY(@NotNull class_2350 direction, class_5819 random, boolean useRandom) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033 -> -0.05;
            case class_2350.field_11036 -> 1.05;
            case class_2350.field_11035, class_2350.field_11043, class_2350.field_11034, class_2350.field_11039 -> 0.5 + (useRandom ? CopperFanBlock.getRandomParticleOffset(random) : 0.0);
        };
    }

    private static double getParticleOffsetZ(@NotNull class_2350 direction, class_5819 random, boolean useRandom) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11036, class_2350.field_11033, class_2350.field_11034, class_2350.field_11039 -> 0.5 + (useRandom ? CopperFanBlock.getRandomParticleOffset(random) : 0.0);
            case class_2350.field_11043 -> -0.05;
            case class_2350.field_11035 -> 1.05;
        };
    }

    public void method_9496(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_5819 random) {
        if (!((Boolean)state.method_11654((class_2769)POWERED)).booleanValue() || random.method_43057() > 0.1f) {
            return;
        }
        float humStrength = class_3532.method_16439((float)((float)this.cosmeticStrength), (float)0.5f, (float)1.0f);
        level.method_45446(pos, TCASounds.BLOCK_COPPER_FAN_IDLE_HUM, class_3419.field_15245, humStrength * 0.75f, humStrength, false);
    }

    @NotNull
    protected class_2680 method_9598(@NotNull class_2680 blockState, @NotNull class_2470 rotation) {
        return (class_2680)blockState.method_11657((class_2769)field_10927, (Comparable)rotation.method_10503((class_2350)blockState.method_11654((class_2769)field_10927)));
    }

    @NotNull
    protected class_2680 method_9569(@NotNull class_2680 blockState, @NotNull class_2415 mirror) {
        return blockState.method_26186(mirror.method_10345((class_2350)blockState.method_11654((class_2769)field_10927)));
    }

    protected void method_9515(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_10927, POWERED});
    }

    @Environment(value=EnvType.CLIENT)
    private static void addWindDisturbanceToClient(@NotNull WindDisturbance windDisturbance) {
        ClientWindManager.addWindDisturbance((WindDisturbance)windDisturbance);
    }
}

