/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.thecopperierage.client.renderer.blockentity;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.lib.render.FrozenLibRenderTypes;
import net.frozenblock.thecopperierage.block.ChimeBlock;
import net.frozenblock.thecopperierage.block.entity.ChimeBlockEntity;
import net.frozenblock.thecopperierage.block.state.properties.ChimeAttachType;
import net.frozenblock.thecopperierage.client.TCAModelLayers;
import net.frozenblock.thecopperierage.client.model.ChimeModel;
import net.frozenblock.thecopperierage.client.renderer.blockentity.state.ChimeRenderState;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class ChimeRenderer<T extends ChimeBlockEntity>
implements class_827<T, ChimeRenderState> {
    private final ChimeModel model;
    private final ChimeModel chainsModel;

    public ChimeRenderer(@NotNull class_5614.class_5615 context) {
        this.model = new ChimeModel(context.method_32140(TCAModelLayers.CHIME), class_1921::method_23576, false);
        this.chainsModel = new ChimeModel(context.method_32140(TCAModelLayers.CHIME), FrozenLibRenderTypes::entityCutoutNoShading, true);
    }

    public void submit(@NotNull ChimeRenderState renderState, @NotNull class_4587 poseStack, @NotNull class_11659 submitNodeCollector, @NotNull class_12075 cameraRenderState) {
        poseStack.method_22903();
        poseStack.method_46416(0.5f, 1.5f, 0.5f);
        poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(-180.0f));
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-renderState.visualDirection.method_10144()));
        submitNodeCollector.method_73489((class_3879)this.model, (Object)renderState, poseStack, this.model.method_23500(renderState.texture), renderState.field_62676, class_4608.field_21444, 0, renderState.field_62677);
        submitNodeCollector.method_73489((class_3879)this.chainsModel, (Object)renderState, poseStack, this.chainsModel.method_23500(renderState.texture), renderState.field_62676, class_4608.field_21444, 0, renderState.field_62677);
        poseStack.method_22909();
    }

    @NotNull
    public ChimeRenderState createRenderState() {
        return new ChimeRenderState();
    }

    public void extractRenderState(@NotNull T chime, @NotNull ChimeRenderState renderState, float partialTick, @NotNull class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        super.method_74331(chime, (class_11954)renderState, partialTick, cameraPos, crumblingOverlay);
        class_2680 state = chime.method_11010();
        renderState.extractTexture(state);
        renderState.animationProgress = ((float)((ChimeBlockEntity)((Object)chime)).age + partialTick + ((ChimeBlockEntity)((Object)chime)).animationOffset + class_3532.method_16439((float)partialTick, (float)((ChimeBlockEntity)((Object)chime)).prevAccumulatedStrength, (float)((ChimeBlockEntity)((Object)chime)).accumulatedStrength)) * 0.15f;
        class_2350 facing = (class_2350)state.method_11654(ChimeBlock.FACING);
        renderState.hanging = state.method_11654(ChimeBlock.ATTACHMENT) == ChimeAttachType.CEILING;
        renderState.direction = facing;
        renderState.visualDirection = facing.method_10166() == class_2350.class_2351.field_11051 ? facing.method_10153() : facing;
        renderState.influence = ((ChimeBlockEntity)((Object)chime)).getInfluence(partialTick).method_1021(0.4);
        renderState.relativeInfluence = renderState.influence.method_1024(facing.method_10144() * ((float)Math.PI / 180));
    }
}

