/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.thecopperierage.mod_compat;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.lib.integration.api.ModIntegration;
import net.frozenblock.lib.sound.api.predicate.SoundPredicate;
import net.frozenblock.lib.wind.api.WindDisturbance;
import net.frozenblock.lib.wind.api.WindDisturbanceLogic;
import net.frozenblock.lib.worldgen.structure.api.BlockStateRespectingProcessorRule;
import net.frozenblock.lib.worldgen.structure.api.BlockStateRespectingRuleProcessor;
import net.frozenblock.lib.worldgen.structure.api.StructureProcessorApi;
import net.frozenblock.lib.worldgen.structure.api.TemplatePoolApi;
import net.frozenblock.thecopperierage.TCAConstants;
import net.frozenblock.thecopperierage.block.CopperFanBlock;
import net.frozenblock.thecopperierage.config.TCAConfig;
import net.frozenblock.thecopperierage.registry.TCABlocks;
import net.frozenblock.thecopperierage.registry.TCAResources;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3491;
import net.minecraft.class_3532;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3818;
import net.minecraft.class_3819;
import net.minecraft.class_3825;
import net.minecraft.class_5469;
import net.minecraft.class_6880;
import net.minecraft.class_7058;
import net.minecraft.class_7430;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrozenLibIntegration
extends ModIntegration {
    public static final class_2960 INSTRUMENT_SOUND_PREDICATE = TCAConstants.id("instrument");
    public static final class_2960 COPPER_FAN_WIND_DISTURBANCE = TCAConstants.id("copper_fan");
    public static final class_2960 COPPER_FAN_WIND_DISTURBANCE_REVERSE = TCAConstants.id("copper_fan_reverse");

    public FrozenLibIntegration() {
        super("frozenlib");
    }

    public void initPreFreeze() {
        SoundPredicate.register((class_2960)INSTRUMENT_SOUND_PREDICATE, () -> new SoundPredicate.LoopPredicate<class_1309>(this){
            private boolean firstCheck = true;
            private class_1799 lastStack;

            public Boolean firstTickTest(class_1309 entity) {
                return true;
            }

            public boolean test(class_1309 entity) {
                if (this.firstCheck) {
                    class_1268 hand;
                    this.firstCheck = false;
                    Object object = !entity.method_5998(class_1268.field_5808).method_7960() ? class_1268.field_5808 : (hand = !entity.method_5998(class_1268.field_5810).method_7960() ? class_1268.field_5810 : null);
                    if (hand == null) {
                        return false;
                    }
                    class_1799 stack = entity.method_5998(hand);
                    if (!(stack.method_7909() instanceof class_7430)) {
                        return false;
                    }
                    this.lastStack = stack;
                    return true;
                }
                class_1799 stack = entity.method_6030();
                if (stack.method_7909() instanceof class_7430) {
                    if (this.lastStack == null || class_1799.method_7973((class_1799)this.lastStack, (class_1799)stack)) {
                        this.lastStack = stack;
                        return true;
                    }
                    this.firstCheck = true;
                }
                return false;
            }
        });
        WindDisturbanceLogic.register((class_2960)COPPER_FAN_WIND_DISTURBANCE, (source, level, windOrigin, affectedArea, windTarget) -> FrozenLibIntegration.getCopperFanDisturbanceResult(source, level, windOrigin, windTarget, false, 1.0));
        WindDisturbanceLogic.register((class_2960)COPPER_FAN_WIND_DISTURBANCE_REVERSE, (source, level, windOrigin, affectedArea, windTarget) -> FrozenLibIntegration.getCopperFanDisturbanceResult(source, level, windOrigin, windTarget, true, 0.8));
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable WindDisturbance.DisturbanceResult getCopperFanDisturbanceResult(@NotNull Optional<CopperFanBlock> source, class_1937 level, class_243 windOrigin, class_243 windTarget, boolean reverse, double windIntensityScale) {
        if (source.isEmpty()) {
            return null;
        }
        class_2338 pos = class_2338.method_49638((class_2374)windOrigin);
        class_2680 state = level.method_8320(pos);
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof CopperFanBlock)) {
            return null;
        }
        CopperFanBlock copperFanBlock = (CopperFanBlock)class_22482;
        double fanDistance = (double)(!reverse ? copperFanBlock.pushBlocks : copperFanBlock.suckBlocks) + 1.0;
        class_2350 direction = (class_2350)state.method_11654((class_2769)CopperFanBlock.field_10927);
        class_243 movement = class_243.method_24954((class_2382)direction.method_62675());
        double strength = fanDistance - Math.min(windTarget.method_1022(windOrigin), fanDistance);
        double intensity = strength / fanDistance;
        return new WindDisturbance.DisturbanceResult(class_3532.method_15350((double)(intensity * 1.5), (double)0.0, (double)1.0) * windIntensityScale, strength * 1.5 * windIntensityScale, movement.method_1021(intensity * 0.5).method_1021(20.0 * windIntensityScale));
    }

    public void init() {
        TCAConfig config = TCAConfig.get();
        class_2960 trialChambers = class_7058.field_47411.method_29177();
        if (config.copperButtonsInTrialChambers) {
            StructureProcessorApi.addProcessor((class_2960)trialChambers, (class_3491)new BlockStateRespectingRuleProcessor((List)ImmutableList.of((Object)new BlockStateRespectingProcessorRule((class_3825)new class_3819(class_2246.field_10057), (class_3825)class_3818.field_16868, TCABlocks.COPPER_BUTTON.comp_4580()))));
        }
        if (config.copperChestsInTrialChambers) {
            StructureProcessorApi.addProcessor((class_2960)trialChambers, (class_3491)new BlockStateRespectingRuleProcessor((List)ImmutableList.of((Object)new BlockStateRespectingProcessorRule((class_3825)new class_3819(class_2246.field_10034), (class_3825)class_3818.field_16868, class_2246.field_61392))));
        }
        if (config.copperPressurePlatesInTrialChambers) {
            StructureProcessorApi.addProcessor((class_2960)trialChambers, (class_3491)new BlockStateRespectingRuleProcessor((List)ImmutableList.of((Object)new BlockStateRespectingProcessorRule((class_3825)new class_3819(class_2246.field_10484), (class_3825)class_3818.field_16868, TCABlocks.WEIGHTED_PRESSURE_PLATE.comp_4580()))));
        }
        TemplatePoolApi.ADD_ADDITIONAL_TEMPLATE_POOLS.register((processorLookup, context) -> {
            if (!TCAResources.HAS_TRICKIER_TRIALS_PACK) {
                return;
            }
            class_6880 copperBulbDegradation = (class_6880)processorLookup.method_46746(class_5469.field_51848).orElseGet(() -> processorLookup.method_46747(class_5469.field_26688));
            class_2960 hallway = class_2960.method_60656((String)"trial_chambers/hallway");
            class_2960 end = class_2960.method_60656((String)"trial_chambers/chambers/end");
            context.addElement(hallway, class_3784.method_30435((String)TCAConstants.string("trial_chambers/chamber/gated_treasure"), (class_6880)copperBulbDegradation), 150, class_3785.class_3786.field_16687);
            context.addElement(hallway, class_3784.method_30435((String)TCAConstants.string("trial_chambers/chamber/jumping_wind"), (class_6880)copperBulbDegradation), 150, class_3785.class_3786.field_16687);
            context.addElement(hallway, class_3784.method_30435((String)TCAConstants.string("trial_chambers/chamber/mexican_restaurant"), (class_6880)copperBulbDegradation), 150, class_3785.class_3786.field_16687);
            context.addElement(hallway, class_3784.method_30435((String)TCAConstants.string("trial_chambers/chamber/wind_chamber"), (class_6880)copperBulbDegradation), 150, class_3785.class_3786.field_16687);
            context.addElement(hallway, class_3784.method_30435((String)TCAConstants.string("trial_chambers/chamber/wind_trap"), (class_6880)copperBulbDegradation), 150, class_3785.class_3786.field_16687);
            context.addElement(hallway, class_3784.method_30435((String)TCAConstants.string("trial_chambers/chamber/windy_pit"), (class_6880)copperBulbDegradation), 150, class_3785.class_3786.field_16687);
            context.addElement(hallway, class_3784.method_30435((String)TCAConstants.string("trial_chambers/hallway/factory_encounter"), (class_6880)copperBulbDegradation), 50, class_3785.class_3786.field_16687);
            context.addElement(hallway, class_3784.method_30435((String)TCAConstants.string("trial_chambers/hallway/large_fan_encounter"), (class_6880)copperBulbDegradation), 50, class_3785.class_3786.field_16687);
            context.addElement(hallway, class_3784.method_30435((String)TCAConstants.string("trial_chambers/hallway/fan_encounter_1"), (class_6880)copperBulbDegradation), 1, class_3785.class_3786.field_16687);
            context.addElement(hallway, class_3784.method_30435((String)TCAConstants.string("trial_chambers/hallway/fan_encounter_2"), (class_6880)copperBulbDegradation), 1, class_3785.class_3786.field_16687);
            context.addElement(hallway, class_3784.method_30435((String)TCAConstants.string("trial_chambers/hallway/fan_encounter_3"), (class_6880)copperBulbDegradation), 1, class_3785.class_3786.field_16687);
            context.addElement(end, class_3784.method_30435((String)TCAConstants.string("trial_chambers/chamber/fan_eruption"), (class_6880)copperBulbDegradation), 1, class_3785.class_3786.field_16687);
        });
    }

    @Environment(value=EnvType.CLIENT)
    public void clientInit() {
    }
}

